/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.item.ItemInfinityLauncher;
import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class IFAttachments {
    public static final DeferredRegister<DataComponentType<?>> DR = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"industrialforegoing");
    public static final Supplier<DataComponentType<ItemInfinityLauncher.PlungerAction>> PLUNGER_ACTION = IFAttachments.register("configuration_action", () -> ItemInfinityLauncher.PlungerAction.RELEASE, builder -> builder.persistent(ItemInfinityLauncher.PlungerAction.CODEC));
    public static final Supplier<DataComponentType<Boolean>> INFINITY_ITEM_CAN_CHARGE = IFAttachments.register("infinity_can_charge", () -> true, op -> op.persistent((Codec)Codec.BOOL));
    public static final Supplier<DataComponentType<Boolean>> INFINITY_MAGNET_ENABLED = IFAttachments.register("infinity_backpack_magnet_enabled", () -> true, op -> op.persistent((Codec)Codec.BOOL));
    public static final Supplier<DataComponentType<Integer>> INFINITY_BACKPACK_PICKUP_MODE = IFAttachments.register("infinity_backpack_pickup_mode", () -> 0, op -> op.persistent((Codec)Codec.INT));
    public static final Supplier<DataComponentType<Boolean>> INFINITY_ITEM_SPECIAL = IFAttachments.register("infinity_item_special", () -> false, op -> op.persistent((Codec)Codec.BOOL));
    public static final Supplier<DataComponentType<Boolean>> INFINITY_ITEM_SPECIAL_ENABLED = IFAttachments.register("infinity_item_special_enabled", () -> false, op -> op.persistent((Codec)Codec.BOOL));
    public static final Supplier<DataComponentType<InfinityTier>> INFINITY_ITEM_SELECTED_TIER = IFAttachments.register("infinity_item_selected_tier", () -> InfinityTier.POOR, builder -> builder.persistent(InfinityTier.CODEC));
    public static final Supplier<DataComponentType<String>> INFINITY_BACKPACK_ID = IFAttachments.register("infinity_backpack_id", () -> "", op -> op.persistent((Codec)Codec.STRING));
    public static final Supplier<DataComponentType<Long>> INFINITY_ITEM_POWER = IFAttachments.register("infinity_item_power", () -> 0L, op -> op.persistent((Codec)Codec.LONG));
    public static final Supplier<DataComponentType<CompoundTag>> INFINITY_TANKS = IFAttachments.register("infinity_tank", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<Integer>> INFINITY_HAMMER_BEHEADING = IFAttachments.register("infinity_hammer_beheading", () -> 0, op -> op.persistent((Codec)Codec.INT));
    public static final Supplier<DataComponentType<Integer>> INFINITY_TRIDENT_LOYALTY = IFAttachments.register("infinity_trident_loyalty", () -> 0, op -> op.persistent((Codec)Codec.INT));
    public static final Supplier<DataComponentType<Integer>> INFINITY_TRIDENT_RIPTIDE = IFAttachments.register("infinity_trident_riptide", () -> 0, op -> op.persistent((Codec)Codec.INT));
    public static final Supplier<DataComponentType<Boolean>> INFINITY_TRIDENT_CHANNELING = IFAttachments.register("infinity_trident_channeling", () -> false, op -> op.persistent((Codec)Codec.BOOL));
    public static final Supplier<DataComponentType<CompoundTag>> MOB_IMPRISONMENT_TOOL = IFAttachments.register("mob_imprisonment", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<String>> ORE_FLUID_TAG = IFAttachments.register("ore_fluid_nbt", () -> "", op -> op.persistent((Codec)Codec.STRING));
    public static final Supplier<DataComponentType<CompoundTag>> SETTINGS_COPIER = IFAttachments.register("settings_copier", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> HYDROPONIC_SIMULATION_PROCESSOR = IFAttachments.register("hydroponic_simulation_processor", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));

    private static <T> ComponentSupplier<T> register(String name, Supplier<T> defaultVal, UnaryOperator<DataComponentType.Builder<T>> op) {
        DeferredHolder registered = DR.register(name, () -> ((DataComponentType.Builder)op.apply(DataComponentType.builder())).build());
        return new ComponentSupplier<T>(registered, defaultVal);
    }

    public static RegistryAccess registryAccess() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return ServerLifecycleHooks.getCurrentServer().registryAccess();
        }
        return ((Level)((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).orElseThrow()).registryAccess();
    }

    public static class ComponentSupplier<T>
    implements Supplier<DataComponentType<T>> {
        private final Supplier<DataComponentType<T>> type;
        private final Supplier<T> defaultSupplier;

        public ComponentSupplier(Supplier<DataComponentType<T>> type, Supplier<T> defaultSupplier) {
            this.type = type;
            this.defaultSupplier = Suppliers.memoize(defaultSupplier::get);
        }

        public T get(ItemStack stack) {
            return (T)stack.getOrDefault(this.type, this.defaultSupplier.get());
        }

        @Override
        public DataComponentType<T> get() {
            return this.type.get();
        }
    }
}

