/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.DyeMixerConfig;
import com.buuz135.industrial.gui.component.ItemGuiAddon;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.util.FacingUtil;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class DyeMixerTile
extends IndustrialProcessingTile<DyeMixerTile> {
    private static ColorUsage[] colorUsages = new ColorUsage[]{new ColorUsage(1, 1, 1), new ColorUsage(1, 1, 1), new ColorUsage(1, 0, 1), new ColorUsage(0, 0, 1), new ColorUsage(0, 1, 1), new ColorUsage(0, 1, 0), new ColorUsage(1, 0, 0), new ColorUsage(1, 1, 1), new ColorUsage(1, 1, 1), new ColorUsage(0, 0, 1), new ColorUsage(1, 0, 1), new ColorUsage(0, 0, 3), new ColorUsage(1, 1, 1), new ColorUsage(0, 3, 0), new ColorUsage(3, 0, 0), new ColorUsage(1, 1, 1)};
    private int getPowerPerTick;
    @Save
    private SidedInventoryComponent<DyeMixerTile> inputRed = (SidedInventoryComponent)new SidedInventoryComponent("input_red", 33, 21, 1, 0).setColor(DyeColor.RED).setInputFilter((stack, integer) -> stack.is(Tags.Items.DYES_RED)).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
    @Save
    private SidedInventoryComponent<DyeMixerTile> inputGreen;
    @Save
    private SidedInventoryComponent<DyeMixerTile> inputBlue;
    @Save
    private ProgressBarComponent<DyeMixerTile> red;
    @Save
    private ProgressBarComponent<DyeMixerTile> green;
    @Save
    private ProgressBarComponent<DyeMixerTile> blue;
    @Save
    private SidedInventoryComponent<DyeMixerTile> output;
    @Save
    private int dye;

    public DyeMixerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.DYE_MIXER, 96, 40, blockPos, blockState);
        this.addInventory((InventoryComponent)this.inputRed);
        this.inputGreen = (SidedInventoryComponent)new SidedInventoryComponent("input_green", 33, 40, 1, 1).setColor(DyeColor.GREEN).setInputFilter((stack, integer) -> stack.is(Tags.Items.DYES_GREEN)).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputGreen);
        this.inputBlue = (SidedInventoryComponent)new SidedInventoryComponent("input_blue", 33, 59, 1, 2).setColor(DyeColor.BLUE).setInputFilter((stack, integer) -> stack.is(Tags.Items.DYES_BLUE)).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.inputBlue);
        this.red = new ProgressBarComponent<DyeMixerTile>(53, 20, 300){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<DyeMixerTile>(DyeMixerTile.this.red.getPosX(), DyeMixerTile.this.red.getPosY(), (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        return Arrays.asList(Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"text.industrialforegoing.display.amount_2").getString() + String.valueOf(ChatFormatting.WHITE) + NumberFormat.getNumberInstance(Locale.ROOT).format(DyeMixerTile.this.red.getProgress()) + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + NumberFormat.getNumberInstance(Locale.ROOT).format(DyeMixerTile.this.red.getMaxProgress()))));
                    }
                });
            }
        }.setCanIncrease(tileEntity -> false).setCanReset(tileEntity -> false).setColor(DyeColor.RED);
        this.addProgressBar(this.red);
        this.blue = new ProgressBarComponent<DyeMixerTile>(66, 20, 300){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<DyeMixerTile>(DyeMixerTile.this.blue.getPosX(), DyeMixerTile.this.blue.getPosY(), (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        return Arrays.asList(Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"text.industrialforegoing.display.amount_2").getString() + String.valueOf(ChatFormatting.WHITE) + NumberFormat.getNumberInstance(Locale.ROOT).format(DyeMixerTile.this.blue.getProgress()) + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + NumberFormat.getNumberInstance(Locale.ROOT).format(DyeMixerTile.this.blue.getMaxProgress()))));
                    }
                });
            }
        }.setCanIncrease(tileEntity -> false).setCanReset(tileEntity -> false).setColor(DyeColor.BLUE);
        this.addProgressBar(this.blue);
        this.green = new ProgressBarComponent<DyeMixerTile>(79, 20, 300){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<DyeMixerTile>(DyeMixerTile.this.green.getPosX(), DyeMixerTile.this.green.getPosY(), (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        return Arrays.asList(Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"text.industrialforegoing.display.amount_2").getString() + String.valueOf(ChatFormatting.WHITE) + NumberFormat.getNumberInstance(Locale.ROOT).format(DyeMixerTile.this.green.getProgress()) + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + NumberFormat.getNumberInstance(Locale.ROOT).format(DyeMixerTile.this.green.getMaxProgress()))));
                    }
                });
            }
        }.setCanIncrease(tileEntity -> false).setCanReset(tileEntity -> false).setColor(DyeColor.GREEN);
        this.addProgressBar(this.green);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 134, 58, 1, 3).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.addButton(new ArrowButtonComponent(116, 22, 14, 14, FacingUtil.Sideness.LEFT).setId(1).setPredicate((playerEntity, compoundNBT) -> {
            --this.dye;
            if (this.dye < 0) {
                this.dye = 15;
            }
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(154, 22, 14, 14, FacingUtil.Sideness.RIGHT).setId(2).setPredicate((playerEntity, compoundNBT) -> {
            ++this.dye;
            if (this.dye > 15) {
                this.dye = 0;
            }
            this.markForUpdate();
        }));
        this.getPowerPerTick = DyeMixerConfig.powerPerTick;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new ItemGuiAddon(133, 20){

            @Override
            public ItemStack getItemStack() {
                return new ItemStack((ItemLike)DyeItem.byColor((DyeColor)DyeColor.byId((int)DyeMixerTile.this.dye)));
            }
        });
    }

    @Override
    public boolean canIncrease() {
        this.increaseBar(this.inputRed.getStackInSlot(0), this.red);
        this.increaseBar(this.inputGreen.getStackInSlot(0), this.green);
        this.increaseBar(this.inputBlue.getStackInSlot(0), this.blue);
        ColorUsage color = colorUsages[this.dye];
        ItemStack dye = new ItemStack((ItemLike)DyeItem.byColor((DyeColor)DyeColor.byId((int)this.dye)));
        return this.red.getProgress() >= color.r && this.green.getProgress() >= color.g && this.blue.getProgress() >= color.b && ItemHandlerHelper.insertItem(this.output, (ItemStack)dye, (boolean)true).isEmpty();
    }

    private void increaseBar(ItemStack stack, ProgressBarComponent bar) {
        if (bar.getProgress() + 3 <= bar.getMaxProgress() && !stack.isEmpty()) {
            stack.shrink(1);
            bar.setProgress(bar.getProgress() + 3);
            this.markForUpdate();
        }
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            ItemStack dye = new ItemStack((ItemLike)DyeItem.byColor((DyeColor)DyeColor.byId((int)this.dye)));
            if (ItemHandlerHelper.insertItem(this.output, (ItemStack)dye, (boolean)true).isEmpty()) {
                ColorUsage color = colorUsages[this.dye];
                this.red.setProgress(this.red.getProgress() - color.r);
                this.green.setProgress(this.green.getProgress() - color.g);
                this.blue.setProgress(this.blue.getProgress() - color.b);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)dye, (boolean)false);
                this.markForUpdate();
            }
        };
    }

    protected EnergyStorageComponent<DyeMixerTile> createEnergyStorage() {
        return new EnergyStorageComponent(DyeMixerConfig.maxStoredPower, 10, 20);
    }

    @Override
    protected int getTickPower() {
        return 30;
    }

    @Nonnull
    public DyeMixerTile getSelf() {
        return this;
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.contains("DM_dye")) {
            this.dye = tag.getInt("DM_dye");
        }
        super.loadSettings(player, tag);
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        tag.putInt("DM_dye", this.dye);
        super.saveSettings(player, tag);
    }

    private static class ColorUsage {
        private int r;
        private int g;
        private int b;

        public ColorUsage(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public int getR() {
            return this.r;
        }

        public int getG() {
            return this.g;
        }

        public int getB() {
            return this.b;
        }
    }
}

