/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.transporter;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterVoxelShapes;
import com.buuz135.industrial.proxy.network.TransporterSyncMessage;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.network.Message;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.joml.Vector3f;

public class TransporterType
implements INBTSerializable<CompoundTag> {
    private IBlockContainer container;
    private TransporterTypeFactory factory;
    private Direction side;
    private TransporterTypeFactory.TransporterAction action;

    public TransporterType(IBlockContainer container, TransporterTypeFactory factory, Direction side, TransporterTypeFactory.TransporterAction action) {
        this.container = container;
        this.factory = factory;
        this.side = side;
        this.action = action;
    }

    public Collection<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)this.getFactory().getUpgradeItem(), 1));
        return drops;
    }

    public IBlockContainer getContainer() {
        return this.container;
    }

    public Level getLevel() {
        return this.getContainer().getBlockWorld();
    }

    public BlockPos getPos() {
        return this.getContainer().getBlockPosition();
    }

    public TransporterTypeFactory getFactory() {
        return this.factory;
    }

    public Direction getSide() {
        return this.side;
    }

    public TransporterTypeFactory.TransporterAction getAction() {
        return this.action;
    }

    public void update() {
    }

    public void updateClient() {
    }

    public void handleEntity(Entity entity) {
    }

    public void onUpgradeRemoved() {
    }

    public int getRedstoneOutput() {
        return 0;
    }

    public VoxelShape getBorderBoundingBox() {
        switch (this.side) {
            case DOWN: {
                return TransporterVoxelShapes.DOWN_RING;
            }
            case NORTH: {
                return TransporterVoxelShapes.NORTH_RING;
            }
            case EAST: {
                return TransporterVoxelShapes.EAST_RING;
            }
            case SOUTH: {
                return TransporterVoxelShapes.SOUTH_RING;
            }
            case WEST: {
                return TransporterVoxelShapes.WEST_RING;
            }
            case UP: {
                return TransporterVoxelShapes.UP_RING;
            }
        }
        return Shapes.empty();
    }

    public VoxelShape getCenterBoundingBox() {
        if (this.action == TransporterTypeFactory.TransporterAction.EXTRACT) {
            switch (this.side) {
                case DOWN: {
                    return TransporterVoxelShapes.DOWN_MIDDLE_EXTRACT;
                }
                case NORTH: {
                    return TransporterVoxelShapes.NORTH_MIDDLE_EXTRACT;
                }
                case EAST: {
                    return TransporterVoxelShapes.EAST_MIDDLE_EXTRACT;
                }
                case SOUTH: {
                    return TransporterVoxelShapes.SOUTH_MIDDLE_EXTRACT;
                }
                case WEST: {
                    return TransporterVoxelShapes.WEST_MIDDLE_EXTRACT;
                }
                case UP: {
                    return TransporterVoxelShapes.UP_MIDDLE_EXTRACT;
                }
            }
        }
        switch (this.side) {
            case DOWN: {
                return TransporterVoxelShapes.DOWN_MIDDLE_INSERT;
            }
            case NORTH: {
                return TransporterVoxelShapes.NORTH_MIDDLE_INSERT;
            }
            case EAST: {
                return TransporterVoxelShapes.EAST_MIDDLE_INSERT;
            }
            case SOUTH: {
                return TransporterVoxelShapes.SOUTH_MIDDLE_INSERT;
            }
            case WEST: {
                return TransporterVoxelShapes.WEST_MIDDLE_INSERT;
            }
            case UP: {
                return TransporterVoxelShapes.UP_MIDDLE_INSERT;
            }
        }
        return Shapes.empty();
    }

    public boolean hasGui() {
        return true;
    }

    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
    }

    public void handleRenderSync(Direction origin, CompoundTag compoundNBT) {
    }

    public void syncRender(Direction origin, CompoundTag compoundNBT) {
        IndustrialForegoing.NETWORK.sendToNearby(this.getLevel(), this.getPos(), 32, (Message)new TransporterSyncMessage(this.getPos(), compoundNBT, this.getSide().get3DDataValue(), origin.get3DDataValue()));
    }

    public void addComponentsToGui(List<IGuiComponent> componentList) {
    }

    public boolean ignoresCollision() {
        return false;
    }

    public void toggleAction() {
        this.action = this.action == TransporterTypeFactory.TransporterAction.EXTRACT ? TransporterTypeFactory.TransporterAction.INSERT : TransporterTypeFactory.TransporterAction.EXTRACT;
        this.getContainer().requestSync();
        if (this.getLevel().isClientSide && this.getContainer() instanceof BlockEntity) {
            this.getLevel().getModelDataManager().requestRefresh((BlockEntity)this.getContainer());
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.putBoolean("Insert", this.action == TransporterTypeFactory.TransporterAction.INSERT);
        return compoundNBT;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.action = nbt.getBoolean("Insert") ? TransporterTypeFactory.TransporterAction.INSERT : TransporterTypeFactory.TransporterAction.EXTRACT;
    }

    public float getSpeed() {
        TransporterTile transporterTile;
        IBlockContainer tile = this.getContainer();
        if (tile instanceof TransporterTile && (transporterTile = (TransporterTile)tile).hasAugmentInstalled(AugmentTypes.SPEED)) {
            return AugmentWrapper.getType((ItemStack)transporterTile.getInstalledAugments(AugmentTypes.SPEED).getFirst(), (IAugmentType)AugmentTypes.SPEED);
        }
        return 1.0f;
    }

    public float getEfficiency() {
        TransporterTile transporterTile;
        IBlockContainer tile = this.getContainer();
        if (tile instanceof TransporterTile && (transporterTile = (TransporterTile)tile).hasAugmentInstalled(AugmentTypes.EFFICIENCY)) {
            return (1.0f - AugmentWrapper.getType((ItemStack)transporterTile.getInstalledAugments(AugmentTypes.EFFICIENCY).getFirst(), (IAugmentType)AugmentTypes.EFFICIENCY)) / 0.1f * 32.0f;
        }
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTransfer(Vector3f pos, Direction direction, int step, PoseStack stack, int combinedOverlayIn, MultiBufferSource buffer, float frame, Level level) {
    }
}

