/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gear.crafting.recipe.ConversionRecipe;
import net.silentchaos512.gear.crafting.recipe.FillRepairKitRecipe;
import net.silentchaos512.gear.crafting.recipe.GearPartSwapRecipe;
import net.silentchaos512.gear.crafting.recipe.ModKitRemovePartRecipe;
import net.silentchaos512.gear.crafting.recipe.QuickRepairRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapedGearRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessCompoundPartRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessGearRecipe;
import net.silentchaos512.gear.crafting.recipe.ToolActionRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.CrudeAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.FabricAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.GemAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.MetalAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.SuperAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.press.MaterialPressingRecipe;
import net.silentchaos512.gear.crafting.recipe.press.PressingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.CompoundPartSalvagingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.GearSalvagingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.crafting.recipe.smithing.CoatingSmithingRecipe;
import net.silentchaos512.gear.crafting.recipe.smithing.UpgradeSmithingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapedRecipe;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public final class SgRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"silentgear");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"silentgear");
    public static final DeferredHolder<RecipeType<?>, RecipeType<AlloyRecipe>> COMPOUNDING_TYPE = SgRecipes.registerType(Const.ALLOY_MAKING);
    public static final DeferredHolder<RecipeType<?>, RecipeType<CrudeAlloyRecipe>> ALLOY_MAKING_CRUDE_TYPE = SgRecipes.registerType(Const.ALLOY_MAKING_CRUDE);
    public static final DeferredHolder<RecipeType<?>, RecipeType<FabricAlloyRecipe>> ALLOY_MAKING_FABRIC_TYPE = SgRecipes.registerType(Const.ALLOY_MAKING_FABRIC);
    public static final DeferredHolder<RecipeType<?>, RecipeType<GemAlloyRecipe>> ALLOY_MAKING_GEM_TYPE = SgRecipes.registerType(Const.ALLOY_MAKING_GEM);
    public static final DeferredHolder<RecipeType<?>, RecipeType<MetalAlloyRecipe>> ALLOY_MAKING_METAL_TYPE = SgRecipes.registerType(Const.ALLOY_MAKING_METAL);
    public static final DeferredHolder<RecipeType<?>, RecipeType<SuperAlloyRecipe>> ALLOY_MAKING_SUPER_TYPE = SgRecipes.registerType(Const.ALLOY_MAKING_SUPER);
    public static final DeferredHolder<RecipeType<?>, RecipeType<PressingRecipe>> PRESSING_TYPE = SgRecipes.registerType(Const.PRESSING);
    public static final DeferredHolder<RecipeType<?>, RecipeType<SalvagingRecipe>> SALVAGING_TYPE = SgRecipes.registerType(Const.SALVAGING);
    public static final DeferredHolder<RecipeType<?>, RecipeType<ToolActionRecipe>> TOOL_ACTION_TYPE = SgRecipes.registerType(Const.TOOL_ACTION);
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<ShapelessCompoundPartRecipe>> COMPOUND_PART = SgRecipes.register(Const.COMPOUND_PART, () -> new ExtendedShapelessRecipe.BasicSerializer(ShapelessCompoundPartRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<AlloyRecipe>> COMPOUNDING = SgRecipes.register(Const.ALLOY_MAKING, () -> new AlloyRecipe.Serializer<AlloyRecipe>(AlloyRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<CrudeAlloyRecipe>> ALLOY_MAKING_CRUDE = SgRecipes.register(Const.ALLOY_MAKING_CRUDE, () -> new AlloyRecipe.Serializer<CrudeAlloyRecipe>(CrudeAlloyRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<FabricAlloyRecipe>> ALLOY_MAKING_FABRIC = SgRecipes.register(Const.ALLOY_MAKING_FABRIC, () -> new AlloyRecipe.Serializer<FabricAlloyRecipe>(FabricAlloyRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GemAlloyRecipe>> ALLOY_MAKING_GEM = SgRecipes.register(Const.ALLOY_MAKING_GEM, () -> new AlloyRecipe.Serializer<GemAlloyRecipe>(GemAlloyRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<MetalAlloyRecipe>> ALLOY_MAKING_METAL = SgRecipes.register(Const.ALLOY_MAKING_METAL, () -> new AlloyRecipe.Serializer<MetalAlloyRecipe>(MetalAlloyRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<SuperAlloyRecipe>> ALLOY_MAKING_SUPER = SgRecipes.register(Const.ALLOY_MAKING_SUPER, () -> new AlloyRecipe.Serializer<SuperAlloyRecipe>(SuperAlloyRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<ConversionRecipe>> CONVERSION = SgRecipes.register(Const.CONVERSION, ConversionRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<FillRepairKitRecipe>> FILL_REPAIR_KIT = SgRecipes.register(Const.FILL_REPAIR_KIT, () -> new SimpleCraftingRecipeSerializer(FillRepairKitRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<ModKitRemovePartRecipe>> MOD_KIT_REMOVE_PART = SgRecipes.register(Const.MOD_KIT_REMOVE_PART, () -> new SimpleCraftingRecipeSerializer(ModKitRemovePartRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<PressingRecipe>> PRESSING = SgRecipes.register(Const.PRESSING, () -> new SingleItemRecipe.Serializer<PressingRecipe>(PressingRecipe::new){});
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<MaterialPressingRecipe>> PRESSING_MATERIAL = SgRecipes.register(Const.PRESSING_MATERIAL, () -> new SingleItemRecipe.Serializer<MaterialPressingRecipe>(MaterialPressingRecipe::new){});
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<QuickRepairRecipe>> QUICK_REPAIR = SgRecipes.register(Const.QUICK_REPAIR, () -> new SimpleCraftingRecipeSerializer(QuickRepairRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<SalvagingRecipe>> SALVAGING = SgRecipes.register(Const.SALVAGING, SalvagingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GearSalvagingRecipe>> SALVAGING_GEAR = SgRecipes.register(Const.SALVAGING_GEAR, GearSalvagingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<CompoundPartSalvagingRecipe>> SALVAGING_COMPOUND_PART = SgRecipes.register(Const.SALVAGING_COMPOUND_PART, CompoundPartSalvagingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<ShapedGearRecipe>> SHAPED_GEAR = SgRecipes.register(Const.SHAPED_GEAR_CRAFTING, () -> new ExtendedShapedRecipe.BasicSerializer(ShapedGearRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<ShapelessGearRecipe>> SHAPELESS_GEAR = SgRecipes.register(Const.SHAPELESS_GEAR_CRAFTING, () -> new ExtendedShapelessRecipe.BasicSerializer(ShapelessGearRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<CoatingSmithingRecipe>> SMITHING_COATING = SgRecipes.register(Const.SMITHING_COATING, CoatingSmithingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<UpgradeSmithingRecipe>> SMITHING_UPGRADE = SgRecipes.register(Const.SMITHING_UPGRADE, UpgradeSmithingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GearPartSwapRecipe>> SWAP_GEAR_PART = SgRecipes.register(Const.SWAP_GEAR_PART, () -> new SimpleCraftingRecipeSerializer(GearPartSwapRecipe::new));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<ToolActionRecipe>> TOOL_ACTION = SgRecipes.register(Const.TOOL_ACTION, ToolActionRecipe.Serializer::new);

    private SgRecipes() {
    }

    private static <T extends Recipe<?>> DeferredHolder<RecipeSerializer<?>, RecipeSerializer<T>> register(ResourceLocation id, Supplier<RecipeSerializer<T>> serializer) {
        return RECIPE_SERIALIZERS.register(id.getPath(), serializer);
    }

    public static <T extends Recipe<?>> DeferredHolder<RecipeType<?>, RecipeType<T>> registerType(ResourceLocation name) {
        return RECIPE_TYPES.register(name.getPath(), () -> RecipeType.simple((ResourceLocation)name));
    }

    public static boolean isRepairMaterial(ItemStack gear, ItemStack materialItem) {
        MaterialInstance mat = MaterialInstance.from(materialItem);
        if (mat != null) {
            return mat.getRepairValue(gear) > 0;
        }
        return false;
    }
}

