/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.Lazy;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.item.blueprint.AbstractBlueprintItem;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;

public class PartBlueprintItem
extends AbstractBlueprintItem {
    private final Supplier<PartType> partType;
    private final Lazy<TagKey<Item>> itemTag;

    public PartBlueprintItem(Supplier<PartType> partType, BlueprintType blueprintType, Item.Properties properties) {
        super(properties, blueprintType);
        this.partType = partType;
        this.itemTag = Lazy.of(() -> {
            ResourceLocation id = Objects.requireNonNull(SgRegistries.PART_TYPE.getKey((Object)this.partType.get()));
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("blueprints/" + id.getPath())));
        });
    }

    public PartType getPartType() {
        return this.partType.get();
    }

    @Override
    public PartType getPartType(ItemStack stack) {
        return this.partType.get();
    }

    @Override
    public GearType getGearType(ItemStack stack) {
        return (GearType)GearTypes.NONE.get();
    }

    @Override
    public TagKey<Item> getItemTag() {
        return (TagKey)this.itemTag.get();
    }

    @Override
    protected Component getCraftedName(ItemStack stack) {
        return this.partType.get().getDisplayName();
    }
}

