/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.data.client.CompoundModelBuilder;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.util.NameUtils;

public class CompoundModelsProvider
extends ModelProvider<ItemModelBuilder> {
    public CompoundModelsProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "silentgear", "item", CompoundModelBuilder::new, existingFileHelper);
    }

    public String getName() {
        return "Silent Gear - Compound Item Models";
    }

    protected void registerModels() {
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(this.mcLoc("item/generated"));
        ModelFile.ExistingModelFile itemHandheld = this.getExistingFile(this.mcLoc("item/handheld"));
    }

    protected CompoundModelBuilder gearBuilder(GearItem item) {
        return ((CompoundModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).getPath())).setLoader(Const.GEAR_MODEL_LOADER).setGearType(item.getGearType());
    }

    protected CompoundModelBuilder partBuilder(CompoundPartItem item) {
        CompoundModelBuilder builder = ((CompoundModelBuilder)this.getBuilder(NameUtils.fromItem((ItemLike)item).getPath())).setLoader(Const.COMPOUND_PART_MODEL_LOADER).setGearType(item.getGearType()).setPartType(item.getPartType());
        if (item.getGearType().isArmor() && item.getGearType() != GearTypes.ELYTRA.get()) {
            builder.setTexturePath("part/armor");
            if (item.getGearType().matches((GearType)GearTypes.HELMET.get())) {
                builder.addExtraLayer(SilentGear.getId("blueprint_helmet"));
            }
            if (item.getGearType().matches((GearType)GearTypes.CHESTPLATE.get())) {
                builder.addExtraLayer(SilentGear.getId("blueprint_chestplate"));
            }
            if (item.getGearType().matches((GearType)GearTypes.LEGGINGS.get())) {
                builder.addExtraLayer(SilentGear.getId("blueprint_leggings"));
            }
            if (item.getGearType().matches((GearType)GearTypes.BOOTS.get())) {
                builder.addExtraLayer(SilentGear.getId("blueprint_boots"));
            }
        }
        return builder;
    }
}

