/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.smithing;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ItemLike;

public abstract class GearSmithingRecipe
extends SmithingTransformRecipe {
    protected final Ingredient template;
    protected final Ingredient addition;
    protected final ItemStack gearItem;

    public GearSmithingRecipe(ItemStack gearItem, Ingredient template, Ingredient addition) {
        super(template, Ingredient.of((ItemLike[])new ItemLike[]{gearItem.getItem()}), addition, gearItem);
        this.template = template;
        this.addition = addition;
        this.gearItem = gearItem;
    }

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider registryAccess) {
        ItemStack gearCopy = input.base().transmuteCopy((ItemLike)this.gearItem.getItem(), 1);
        ItemStack upgradeItem = input.addition();
        return this.applyUpgrade(gearCopy, upgradeItem);
    }

    protected abstract ItemStack applyUpgrade(ItemStack var1, ItemStack var2);

    public abstract RecipeSerializer<?> getSerializer();

    @FunctionalInterface
    public static interface Factory<R extends GearSmithingRecipe> {
        public R create(ItemStack var1, Ingredient var2, Ingredient var3);
    }
}

