/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.util;

import java.util.Collection;
import java.util.function.Supplier;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.util.PropertyKey;

public interface PropertyProvider<D> {
    public <T, V extends GearPropertyValue<T>> Collection<V> getPropertyModifiers(D var1, PartType var2, PropertyKey<T, V> var3);

    default public <T, V extends GearPropertyValue<T>> Collection<V> getPropertyModifiers(D instance, Supplier<PartType> partType, PropertyKey<T, V> key) {
        return this.getPropertyModifiers(instance, partType.get(), key);
    }

    default public <T, V extends GearPropertyValue<T>> T getProperty(D instance, PartType partType, PropertyKey<T, V> key) {
        GearProperty<T, V> property = key.property();
        Collection<V> mods = this.getPropertyModifiers(instance, partType, key);
        return property.compute(mods);
    }

    default public <T, V extends GearPropertyValue<T>> T getProperty(D instance, Supplier<PartType> partType, PropertyKey<T, V> key) {
        return this.getProperty(instance, partType.get(), key);
    }

    default public <T, V extends GearPropertyValue<T>> T getPropertyUnclamped(D instance, PartType partType, PropertyKey<T, V> key) {
        GearProperty<T, V> property = key.property();
        Collection<V> mods = this.getPropertyModifiers(instance, partType, key);
        return property.compute(property.getBaseValue(), false, key.gearType(), mods);
    }

    default public <T, V extends GearPropertyValue<T>> T getPropertyUnclamped(D instance, Supplier<PartType> partType, PropertyKey<T, V> key) {
        return this.getPropertyUnclamped(instance, partType.get(), key);
    }
}

