/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.trait;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.api.data.trait.TraitBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class TraitsProviderBase
implements DataProvider {
    protected final DataGenerator generator;
    protected final String modId;

    public TraitsProviderBase(DataGenerator generator, String modId) {
        this.generator = generator;
        this.modId = modId;
    }

    public abstract Collection<TraitBuilder> getTraits();

    @NotNull
    public String getName() {
        return "Silent Gear Traits: " + this.modId;
    }

    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        Path outputFolder = this.generator.getPackOutput().getOutputFolder();
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.getTraits().forEach(builder -> {
            ResourceLocation id = builder.getTrait().getId();
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate trait: " + String.valueOf(id));
            }
            Path path = outputFolder.resolve(String.format("data/%s/silentgear_traits/%s.json", id.getNamespace(), id.getPath()));
            list.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)builder.serialize(), (Path)path));
        });
        return CompletableFuture.allOf(list.toArray(new CompletableFuture[0]));
    }
}

