/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.capability;

import com.google.common.base.Preconditions;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public class BlockCapabilitySource<Capability, Context> {
    private final BlockCapability<Capability, Context> _capability;
    @Nullable
    private final BooleanSupplier _isCacheValidSupplier;
    @Nullable
    private final Runnable _capabilityInvalidationListener;
    @Nullable
    private BlockCapabilityCache<Capability, Context> _cache;

    public static <Capability> BlockCapabilitySource<Capability, @Nullable Direction> sided(BlockCapability<Capability, @Nullable Direction> capability) {
        return new BlockCapabilitySource<Capability, Direction>(capability);
    }

    public static <Capability> BlockCapabilitySource<Capability, @Nullable Direction> sided(BlockCapability<Capability, @Nullable Direction> capability, BooleanSupplier isCacheValidSupplier, Runnable capabilityInvalidationListener) {
        return new BlockCapabilitySource<Capability, Direction>(capability, isCacheValidSupplier, capabilityInvalidationListener);
    }

    public BlockCapabilitySource(BlockCapability<Capability, Context> capability) {
        Preconditions.checkNotNull(capability, (Object)"Capability must not be null");
        this._capability = capability;
        this._isCacheValidSupplier = null;
        this._capabilityInvalidationListener = null;
    }

    public BlockCapabilitySource(BlockCapability<Capability, Context> capability, BooleanSupplier isCacheValidSupplier, Runnable capabilityInvalidationListener) {
        Preconditions.checkNotNull(capability, (Object)"Capability must not be null");
        Preconditions.checkNotNull((Object)isCacheValidSupplier, (Object)"Cache validity supplier must not be null");
        Preconditions.checkNotNull((Object)capabilityInvalidationListener, (Object)"Capability invalidation listener must not be null");
        this._capability = capability;
        this._isCacheValidSupplier = isCacheValidSupplier;
        this._capabilityInvalidationListener = capabilityInvalidationListener;
    }

    public void setSource(ServerLevel level, BlockPos position, @Nullable Context context) {
        Preconditions.checkNotNull((Object)level, (Object)"Level must not be null");
        Preconditions.checkNotNull((Object)position, (Object)"Position must not be null");
        if (null != this._cache && this._cache.level() == level && this._cache.pos().equals((Object)position)) {
            return;
        }
        this._cache = null == this._isCacheValidSupplier && null == this._capabilityInvalidationListener ? BlockCapabilityCache.create(this._capability, (ServerLevel)level, (BlockPos)position, context) : BlockCapabilityCache.create(this._capability, (ServerLevel)level, (BlockPos)position, context, (BooleanSupplier)this._isCacheValidSupplier, (Runnable)this._capabilityInvalidationListener);
    }

    @Nullable
    public Capability getCapability() {
        return (Capability)(null == this._cache ? null : this._cache.getCapability());
    }
}

