/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.lib.CodeHelper;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public record ModCodecs<Type, Buffer extends ByteBuf>(Codec<Type> codec, StreamCodec<Buffer, Type> streamCodec) {
    public <Encoded> DataResult<Encoded> encode(Type value, DynamicOps<Encoded> ops) {
        return this.codec.encodeStart(ops, value);
    }

    public <Encoded> DataResult<Encoded> encode(Type value, DynamicOps<Encoded> ops, Encoded output) {
        return this.codec.encode(value, ops, output);
    }

    public <Encoded> DataResult<Type> decode(Encoded input, DynamicOps<Encoded> ops) {
        return this.codec.parse(ops, input);
    }

    public <Encoded> void encode(Type value, Buffer buffer) {
        this.streamCodec.encode(buffer, value);
    }

    public Type decode(Buffer buffer) {
        return (Type)this.streamCodec.decode(buffer);
    }

    public Codec<List<Type>> listCodec() {
        return this.codec.listOf();
    }

    public Codec<List<Type>> listCodec(int minSize, int maxSize) {
        return this.codec.listOf(minSize, maxSize);
    }

    public <O> RecordCodecBuilder<O, Type> field(String name, Function<O, Type> getter) {
        return this.codec.fieldOf(name).forGetter(getter);
    }

    public <O> RecordCodecBuilder<O, List<Type>> listField(String name, Function<O, List<Type>> getter) {
        return this.listCodec().fieldOf(name).forGetter(getter);
    }

    public <O> RecordCodecBuilder<O, List<Type>> listField(String name, Function<O, List<Type>> getter, int minSize, int maxSize) {
        return this.listCodec(minSize, maxSize).fieldOf(name).forGetter(getter);
    }

    public StreamCodec<Buffer, List<Type>> listStreamCodec() {
        return this.streamCodec.apply(ByteBufCodecs.list());
    }

    public StreamCodec<Buffer, List<Type>> listStreamCodec(int maxSize) {
        return this.streamCodec.apply(ByteBufCodecs.list((int)maxSize));
    }

    public static <T> Codec<NonNullList<T>> nonNullListCodec(Codec<T> elementCodec) {
        return elementCodec.listOf().xmap(NonNullList::copyOf, Function.identity());
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, NonNullList<T>> nonNullListStreamCodec(StreamCodec<RegistryFriendlyByteBuf, T> elementCodec) {
        return elementCodec.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)).map(CodeHelper::asNonNullList, Function.identity());
    }

    public static <T> Codec<TagKey<T>> tagKeyCodec(ResourceKey<? extends Registry<T>> registry) {
        return TagKey.codec(registry);
    }

    public static <T> StreamCodec<ByteBuf, TagKey<T>> tagKeyStreamCodec(ResourceKey<? extends Registry<T>> registry) {
        return ResourceLocation.STREAM_CODEC.map(tagId -> TagKey.create((ResourceKey)registry, (ResourceLocation)tagId), TagKey::location);
    }

    public static <F, S> Codec<Pair<F, S>> pairCodec(Codec<F> firstCodec, Codec<S> secondCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)firstCodec.fieldOf("fist").forGetter(Pair::getFirst), (App)secondCodec.fieldOf("second").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    }

    public static <Buffer, F, S> StreamCodec<Buffer, Pair<F, S>> pairStreamCodec(StreamCodec<? super Buffer, F> firstCodec, StreamCodec<? super Buffer, S> secondCodec) {
        return StreamCodec.composite(firstCodec, Pair::getFirst, secondCodec, Pair::getSecond, Pair::of);
    }
}

