/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.sprite;

import it.zerono.mods.zerocore.lib.client.gui.sprite.AtlasSpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class AtlasSpriteSupplier
implements ResourceManagerReloadListener {
    public static final AtlasSpriteSupplier INSTANCE = new AtlasSpriteSupplier();
    private int _generation = 0;

    public static Supplier<ISprite> create(ResourceLocation spriteName, AtlasSpriteTextureMap map) {
        return new SpriteSupplier(spriteName, map);
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        ++this._generation;
    }

    private AtlasSpriteSupplier() {
    }

    private static class SpriteSupplier
    implements Supplier<ISprite> {
        private final AtlasSpriteTextureMap _map;
        private final ResourceLocation _name;
        private int _lastKnownGeneration;
        private ISprite _cachedSprite;

        protected SpriteSupplier(ResourceLocation name, AtlasSpriteTextureMap map) {
            this._name = name;
            this._map = map;
            this._lastKnownGeneration = -1;
            this._cachedSprite = Sprite.EMPTY;
        }

        @Override
        public ISprite get() {
            if (this._lastKnownGeneration != AtlasSpriteSupplier.INSTANCE._generation) {
                this._cachedSprite = this._map.sprite(this._name);
                this._lastKnownGeneration = AtlasSpriteSupplier.INSTANCE._generation;
            }
            return this._cachedSprite;
        }
    }
}

