/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.client.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.debug.DebugHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import org.joml.Matrix4f;

public class VoxelShapeHighlighter {
    private static final Colour COLOUR_SHAPE = Colour.from(DyeColor.YELLOW);
    private static final Colour COLOUR_RENDERSHAPE = Colour.from(DyeColor.RED);
    private static final Colour COLOUR_COLLISIONSHAPE = Colour.from(DyeColor.BLUE);
    private static final Colour COLOUR_RAYTRACESHAPE = Colour.from(DyeColor.PURPLE);

    @SubscribeEvent
    public static void onHighlightBlock(RenderHighlightEvent.Block event) {
        BlockPos position;
        BlockHitResult result = event.getTarget();
        if (HitResult.Type.BLOCK != result.getType()) {
            return;
        }
        Level world = event.getCamera().getEntity().getCommandSenderWorld();
        DebugHelper.VoxelShapeType voxelType = DebugHelper.getBlockVoxelShapeHighlight(world, position = result.getBlockPos());
        if (DebugHelper.VoxelShapeType.None == voxelType || !world.getWorldBorder().isWithinBounds(position)) {
            return;
        }
        BlockState blockstate = world.getBlockState(position);
        if (blockstate.isAir()) {
            return;
        }
        Camera renderInfo = event.getCamera();
        CollisionContext selection = CollisionContext.of((Entity)renderInfo.getEntity());
        VertexConsumer builder = event.getMultiBufferSource().getBuffer(RenderType.lines());
        PoseStack matrixStack = event.getPoseStack();
        double x = (double)position.getX() - renderInfo.getPosition().x();
        double y = (double)position.getY() - renderInfo.getPosition().y();
        double z = (double)position.getZ() - renderInfo.getPosition().z();
        switch (voxelType) {
            case General: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_SHAPE, blockstate.getShape((BlockGetter)world, position, selection));
                break;
            }
            case Render: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_RENDERSHAPE, blockstate.getBlockSupportShape((BlockGetter)world, position));
                break;
            }
            case Collision: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_COLLISIONSHAPE, blockstate.getCollisionShape((BlockGetter)world, position, selection));
                break;
            }
            case RayTrace: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_RAYTRACESHAPE, blockstate.getVisualShape((BlockGetter)world, position, CollisionContext.empty()));
            }
        }
        event.setCanceled(true);
    }

    private static void paint(PoseStack matrixStack, VertexConsumer vertexBuilder, double originX, double originY, double originZ, Colour colour, VoxelShape voxelShape) {
        Matrix4f matrix = matrixStack.last().pose();
        float red = colour.glRed();
        float green = colour.glGreen();
        float blue = colour.glBlue();
        voxelShape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
            vertexBuilder.addVertex(matrix, (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).setColor(red, green, blue, 0.5f);
            vertexBuilder.addVertex(matrix, (float)(x2 + originX), (float)(y2 + originY), (float)(z2 + originZ)).setColor(red, green, blue, 0.5f);
        });
    }
}

