/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.util.bound;

import com.breakinblocks.plonk.common.util.bound.Box;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.Lazy;

public class BoxCollection {
    private final Entries boxes;
    private final Map<Integer, Entries> boxesById;

    private BoxCollection(ArrayList<Entry> boxes) {
        this.boxes = new Entries(boxes);
        this.boxesById = ((ArrayList)this.boxes.source.get()).stream().collect(Collectors.groupingBy(e -> e.id, Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), Entries::new)));
    }

    public ArrayList<Box> get(int id) {
        return (ArrayList)this.boxesById.getOrDefault((Object)Integer.valueOf((int)id), (Entries)Entries.EMPTY).all.get();
    }

    public int getSelectionIndexFromHitVec(Vec3 hitVec) {
        return ((ArrayList)this.boxes.source.get()).stream().filter(e -> e.selection).map(e -> new SelectionEntry((Entry)e, e.box.distanceSq(hitVec))).reduce((a, b) -> b.distance < a.distance ? b : a).map(se -> se.entry.id).orElse(-1);
    }

    public VoxelShape getShape() {
        return (VoxelShape)this.boxes.shape.get();
    }

    public VoxelShape getCollisionShape() {
        return (VoxelShape)this.boxes.collisionShape.get();
    }

    public VoxelShape getSelectionShape() {
        return (VoxelShape)this.boxes.selectionShape.get();
    }

    public VoxelShape getSelectionShapeById(int id) {
        return (VoxelShape)this.boxesById.getOrDefault((Object)Integer.valueOf((int)id), (Entries)Entries.EMPTY).selectionShape.get();
    }

    public static class Entries {
        public static final Entries EMPTY = new Entries(new ArrayList<Entry>());
        public final Lazy<ArrayList<Entry>> source = Lazy.of(() -> new ArrayList(entries));
        public final Lazy<ArrayList<Box>> all = Lazy.of(() -> ((ArrayList)this.source.get()).stream().map(e -> e.box).collect(Collectors.toCollection(ArrayList::new)));
        public final Lazy<ArrayList<Box>> collision = Lazy.of(() -> ((ArrayList)this.source.get()).stream().filter(e -> e.collision).map(e -> e.box).collect(Collectors.toCollection(ArrayList::new)));
        public final Lazy<ArrayList<Box>> selection = Lazy.of(() -> ((ArrayList)this.source.get()).stream().filter(e -> e.selection).map(e -> e.box).collect(Collectors.toCollection(ArrayList::new)));
        public final Lazy<VoxelShape> shape = Lazy.of(() -> ((ArrayList)this.all.get()).stream().map(Box::toShape).reduce(Shapes::or).orElseGet(Shapes::empty));
        public final Lazy<VoxelShape> collisionShape = Lazy.of(() -> ((ArrayList)this.collision.get()).stream().map(Box::toShape).reduce(Shapes::or).orElseGet(Shapes::empty));
        public final Lazy<VoxelShape> selectionShape = Lazy.of(() -> ((ArrayList)this.selection.get()).stream().map(Box::toShape).reduce(Shapes::or).orElseGet(Shapes::empty));

        public Entries(ArrayList<Entry> entries) {
        }
    }

    private static class SelectionEntry {
        public final Entry entry;
        public final double distance;

        public SelectionEntry(Entry entry, double distance) {
            this.entry = entry;
            this.distance = distance;
        }
    }

    public static class Entry {
        public final int id;
        public final boolean collision;
        public final boolean selection;
        public final Box box;

        public Entry(int id, boolean collision, boolean selection, Box box) {
            this.id = id;
            this.collision = collision;
            this.selection = selection;
            this.box = box;
        }
    }

    public static class Builder {
        private ArrayList<Entry> boxes = new ArrayList();
        private boolean collision;
        private boolean selection;

        public Builder(boolean collision, boolean selection) {
            this.collision = collision;
            this.selection = selection;
        }

        public Builder() {
            this(true, true);
        }

        public Builder setCollision(boolean collision) {
            this.collision = collision;
            return this;
        }

        public Builder setSelection(boolean selection) {
            this.selection = selection;
            return this;
        }

        public Builder addBox(int id, Box box) {
            this.boxes.add(new Entry(id, this.collision, this.selection, box));
            return this;
        }

        public Builder addBox(int id, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            return this.addBox(id, new Box(minX, minY, minZ, maxX, maxY, maxZ));
        }

        public Builder addBoxes(BoxCollection boxCollection) {
            this.boxes.addAll((Collection)boxCollection.boxes.source.get());
            return this;
        }

        public Builder apply(Function<Box, Box> transform) {
            this.boxes = this.boxes.stream().map(e -> new Entry(e.id, e.collision, e.selection, (Box)transform.apply(e.box))).collect(Collectors.toCollection(ArrayList::new));
            return this;
        }

        public BoxCollection build() {
            return new BoxCollection(this.boxes);
        }
    }
}

