/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WorldUtils {
    @Nullable
    public static <TILE extends BlockEntity> TILE getTileEntity(BlockGetter world, BlockPos pos, Class<TILE> clazz) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (clazz.isInstance(tile)) {
            return (TILE)((BlockEntity)clazz.cast(tile));
        }
        return null;
    }

    public static <TILE extends BlockEntity> void withTile(BlockGetter world, BlockPos pos, Class<TILE> clazz, Consumer<TILE> consumer) {
        TILE tile = WorldUtils.getTileEntity(world, pos, clazz);
        if (tile != null) {
            consumer.accept(tile);
        }
    }

    public static <TILE extends BlockEntity, RETURN> RETURN withTile(BlockGetter world, BlockPos pos, Class<TILE> clazz, Function<TILE, RETURN> func, Supplier<RETURN> def) {
        TILE tile = WorldUtils.getTileEntity(world, pos, clazz);
        if (tile != null) {
            return func.apply(tile);
        }
        return def.get();
    }
}

