/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.util;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class ItemUtils {
    @Nullable
    public static ItemEntity dropItemOnEntity(LivingEntity entity, ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        ItemEntity entityItem = new ItemEntity(entity.level(), x, y, z, stack.copy());
        return entity.level().addFreshEntity((Entity)entityItem) ? entityItem : null;
    }

    public static ItemStack insertStack(Container inv, ItemStack stack) {
        return ItemUtils.insertStackAdv((Container)inv, (ItemStack)stack).remainder;
    }

    public static InsertStackResult insertStackAdv(Container inv, ItemStack stack) {
        if (stack.isEmpty()) {
            return new InsertStackResult(stack, new int[0]);
        }
        int stackSizeLimit = Math.min(stack.getMaxStackSize(), inv.getMaxStackSize());
        int size = inv.getContainerSize();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        ItemStack remainder = stack;
        for (int slot = 0; slot < size && !remainder.isEmpty(); ++slot) {
            int toTransfer;
            ItemStack current;
            if (!inv.canPlaceItem(slot, stack) || !(current = inv.getItem(slot)).isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)remainder) || (toTransfer = Math.min(current.getCount() + remainder.getCount(), stackSizeLimit) - current.getCount()) <= 0) continue;
            if (current.isEmpty()) {
                current = remainder.copy();
                current.setCount(toTransfer);
            } else {
                current.setCount(current.getCount() + toTransfer);
            }
            if (remainder == stack) {
                remainder = stack.copy();
            }
            remainder.setCount(remainder.getCount() - toTransfer);
            inv.setItem(slot, current);
            slots.add(slot);
        }
        int[] slotsArray = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            slotsArray[i] = (Integer)slots.get(i);
        }
        return new InsertStackResult(remainder, slotsArray);
    }

    public static int getMaxStackSize() {
        return Objects.requireNonNull((Integer)DataComponents.COMMON_ITEM_COMPONENTS.get(DataComponents.MAX_STACK_SIZE));
    }

    public static ResourceLocation getIdentifier(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
    }

    public static class InsertStackResult {
        public final ItemStack remainder;
        public final int[] slots;

        public InsertStackResult(ItemStack remainder, int[] slots) {
            this.remainder = remainder;
            this.slots = slots;
        }
    }
}

