/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.packet;

import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public record PacketRotateTile(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketRotateTile> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"plonk", (String)"rotate_tile"));
    public static final StreamCodec<ByteBuf, PacketRotateTile> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketRotateTile::pos, PacketRotateTile::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void register(PayloadRegistrar registrar) {
        registrar.playToServer(TYPE, STREAM_CODEC, PacketRotateTile::handle);
    }

    private static void handle(PacketRotateTile payload, IPayloadContext context) {
        BlockEntity te;
        ServerPlayer player = (ServerPlayer)Objects.requireNonNull(context.player());
        ServerLevel world = player.serverLevel();
        double reach = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 2.0;
        if (player.distanceToSqr((double)payload.pos.getX() + 0.5, (double)payload.pos.getY() + 0.5, (double)payload.pos.getZ() + 0.5) < reach * reach && (te = world.getBlockEntity(payload.pos)) instanceof TilePlacedItems) {
            ((TilePlacedItems)te).rotateTile();
        }
    }
}

