/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.item;

import com.breakinblocks.plonk.common.config.PlonkConfig;
import com.breakinblocks.plonk.common.registry.RegistryBlocks;
import com.breakinblocks.plonk.common.registry.RegistryDataComponents;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class ItemBlockPlacedItems
extends BlockItem {
    public ItemBlockPlacedItems(Item.Properties builder) {
        super((Block)RegistryBlocks.placed_items, builder);
    }

    public void setHeldStack(ItemStack stack, ItemStack held, int renderType) {
        Data data = (Data)stack.getComponents().getOrDefault(RegistryDataComponents.ITEM_BLOCK_PLACED_ITEMS_DATA, (Object)Data.DEFAULT);
        data = data.withHeld(held);
        data = data.withRenderType(renderType);
        stack.set(RegistryDataComponents.ITEM_BLOCK_PLACED_ITEMS_DATA, (Object)data);
    }

    public ItemStack getHeldStack(ItemStack stack) {
        Data data = (Data)stack.getComponents().getOrDefault(RegistryDataComponents.ITEM_BLOCK_PLACED_ITEMS_DATA, (Object)Data.DEFAULT);
        if (data.held == null) {
            return ItemStack.EMPTY;
        }
        return data.held;
    }

    public int getHeldRenderType(ItemStack stack) {
        Data data = (Data)stack.getComponents().getOrDefault(RegistryDataComponents.ITEM_BLOCK_PLACED_ITEMS_DATA, (Object)Data.DEFAULT);
        return data.renderType;
    }

    protected boolean tryInsertStack(UseOnContext context, TilePlacedItems tile) {
        ItemStack heldItem = this.getHeldStack(context.getItemInHand());
        int renderType = this.getHeldRenderType(context.getItemInHand());
        ItemStack remainder = tile.insertStack(heldItem, renderType);
        tile.setChanged();
        tile.clean();
        if (remainder != heldItem) {
            this.setHeldStack(context.getItemInHand(), remainder, renderType);
            return true;
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack heldStack = this.getHeldStack(context.getItemInHand());
        if (heldStack.isEmpty() || !PlonkConfig.canPlace(heldStack)) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        TilePlacedItems tile = null;
        if (world.getBlockState(pos).getBlock() == RegistryBlocks.placed_items) {
            tile = (TilePlacedItems)world.getBlockEntity(pos);
        } else {
            BlockPos pos2 = pos.relative(facing);
            if (world.getBlockState(pos2).getBlock() == RegistryBlocks.placed_items) {
                tile = (TilePlacedItems)world.getBlockEntity(pos2);
            }
        }
        Player player = context.getPlayer();
        if (tile != null && this.tryInsertStack(context, tile)) {
            BlockState state = world.getBlockState(pos);
            SoundType soundtype = state.getBlock().getSoundType(state, (LevelReader)world, pos, (Entity)player);
            world.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public boolean placeBlock(BlockPlaceContext context, BlockState newState) {
        ItemStack heldStack = this.getHeldStack(context.getItemInHand());
        if (heldStack.isEmpty()) {
            return false;
        }
        if (!super.placeBlock(context, newState)) {
            return false;
        }
        TilePlacedItems tile = (TilePlacedItems)context.getLevel().getBlockEntity(context.getClickedPos());
        if (tile == null) {
            return false;
        }
        return this.tryInsertStack((UseOnContext)context, tile);
    }

    public record Data(ItemStack held, int renderType) {
        public static final Data DEFAULT = new Data(ItemStack.EMPTY, 0);
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, Data::held, (StreamCodec)ByteBufCodecs.VAR_INT, Data::renderType, Data::new);
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("Held").forGetter(Data::held), (App)Codec.INT.optionalFieldOf("RenderType", (Object)0).forGetter(Data::renderType)).apply((Applicative)instance, Data::new));

        public Data withHeld(ItemStack held) {
            return new Data(held, this.renderType);
        }

        public Data withRenderType(int renderType) {
            return new Data(this.held, renderType);
        }
    }
}

