/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.config;

import com.breakinblocks.plonk.common.tag.PlonkTags;
import com.breakinblocks.plonk.common.util.ItemUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class PlonkConfig {
    public static final ModConfigSpec serverSpec;
    private static final Server SERVER;

    public static int getInventoryStackLimit() {
        int maxStackSize = (Integer)PlonkConfig.SERVER.maxStackSize.get();
        return maxStackSize <= 0 ? ItemUtils.getMaxStackSize() : maxStackSize;
    }

    public static boolean canPlace(ItemStack stack) {
        if (stack.is(PlonkTags.Items.UNPLACEABLE)) {
            return false;
        }
        return !PlonkConfig.SERVER.unplaceableItemsSet.contains(ItemUtils.getIdentifier(stack));
    }

    public static void refresh(ModConfigEvent event) {
        if (event instanceof ModConfigEvent.Unloading) {
            return;
        }
        ModConfig modConfig = event.getConfig();
        IConfigSpec spec = modConfig.getSpec();
        if (spec == serverSpec) {
            SERVER.refresh();
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Server::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    private static class Server {
        public final ModConfigSpec.IntValue maxStackSize;
        private final ModConfigSpec.ConfigValue<List<? extends String>> unplaceableItems;
        public Set<ResourceLocation> unplaceableItemsSet = Collections.emptySet();

        Server(ModConfigSpec.Builder builder) {
            this.maxStackSize = builder.comment("Max stack size per slot (-1 or 0 to use default). Going above 64 needs a mod like StackUp!.").defineInRange("maxStackSize", -1, -1, Integer.MAX_VALUE);
            this.unplaceableItems = builder.comment(new String[]{"Items that cannot be placed down, in the format \"mod_id:item_id\" e.g. [\"minecraft:carrot\"]", "You can also use the " + String.valueOf(PlonkTags.Items.UNPLACEABLE.location()) + " item tag as well."}).defineListAllowEmpty("unplaceableItems", Collections.emptyList(), () -> "", o -> o instanceof String && ResourceLocation.tryParse((String)((String)o)) != null);
        }

        public void refresh() {
            this.unplaceableItemsSet = ((List)this.unplaceableItems.get()).stream().map(ResourceLocation::parse).collect(Collectors.toSet());
        }
    }
}

