/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.client;

import com.breakinblocks.plonk.client.command.CommandClientPlonk;
import com.breakinblocks.plonk.client.registry.RegistryTESRs;
import com.breakinblocks.plonk.client.render.tile.TESRPlacedItems;
import com.breakinblocks.plonk.common.packet.PacketPlaceItem;
import com.breakinblocks.plonk.common.packet.PacketRotateTile;
import com.breakinblocks.plonk.common.registry.RegistryItems;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import com.breakinblocks.plonk.common.util.EntityUtils;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClientEvents {
    public static final KeyMapping KEY_PLACE = new KeyMapping("key.plonk.place", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 80, "key.categories.plonk");

    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(ClientEvents::setupClient);
        modEventBus.addListener(ClientEvents::onRegisterKeyMappings);
        NeoForge.EVENT_BUS.addListener(ClientEvents::onKeyInput);
        NeoForge.EVENT_BUS.addListener(ClientEvents::serverStarting);
    }

    public static void setupClient(FMLClientSetupEvent event) {
        RegistryTESRs.init();
    }

    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(KEY_PLACE);
    }

    public static void onKeyInput(InputEvent.Key event) {
        HitResult hitRaw;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (mc.getOverlay() == null && mc.screen == null && KEY_PLACE.consumeClick() && player != null && (hitRaw = mc.hitResult) != null && hitRaw.getType() == HitResult.Type.BLOCK) {
            BlockHitResult hit = (BlockHitResult)hitRaw;
            ItemStack held = player.getMainHandItem();
            if (!held.isEmpty()) {
                int renderType = TESRPlacedItems.getRenderTypeFromStack(held);
                ItemStack toPlace = new ItemStack((ItemLike)RegistryItems.placed_items, 1);
                RegistryItems.placed_items.setHeldStack(toPlace, held, renderType);
                EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, toPlace);
                if (toPlace.useOn(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, hit)).consumesAction()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PacketPlaceItem(hit, renderType), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ItemStack newHeld = RegistryItems.placed_items.getHeldStack(toPlace);
                    EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, newHeld);
                } else {
                    EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, held);
                }
            } else if (player.isShiftKeyDown() && !ClientEvents.rotatePlacedItemsTile(player.level(), hit.getBlockPos())) {
                ClientEvents.rotatePlacedItemsTile(player.level(), hit.getBlockPos().relative(hit.getDirection()));
            }
        }
    }

    private static boolean rotatePlacedItemsTile(Level world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof TilePlacedItems) {
            ((TilePlacedItems)te).rotateTile();
            PacketDistributor.sendToServer((CustomPacketPayload)new PacketRotateTile(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return false;
    }

    public static void serverStarting(ServerStartingEvent event) {
        new CommandClientPlonk().register((CommandDispatcher<CommandSourceStack>)event.getServer().getCommands().getDispatcher());
    }
}

