/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.potion.PotionHelperCommonCapabilities;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;

public class VanillaBrewingStandRecipeHandler
implements IRecipeHandler {
    private static final VanillaBrewingStandRecipeHandler INSTANCE = new VanillaBrewingStandRecipeHandler();
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_INPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_OUTPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    private static final int[] OUTPUT_SLOTS = new int[]{1, 2, 3};

    private VanillaBrewingStandRecipeHandler() {
    }

    public static VanillaBrewingStandRecipeHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return COMPONENTS_INPUT;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return COMPONENTS_OUTPUT;
    }

    public boolean isValidSizeInput(IngredientComponent component, int size) {
        return component == IngredientComponent.ITEMSTACK && (size >= 2 || size <= 4);
    }

    public List<IRecipeDefinition> getRecipes() {
        return PotionHelperCommonCapabilities.getVanillaRecipes();
    }

    @Override
    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        List<ItemStack> recipeIngredients = input.getInstances(IngredientComponent.ITEMSTACK);
        if (input.getComponents().size() != 1 || !this.isValidSizeInput((IngredientComponent)IngredientComponent.ITEMSTACK, recipeIngredients.size())) {
            return null;
        }
        NonNullList brewingItemStacks = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        PotionBrewing potionbrewing = ServerLifecycleHooks.getCurrentServer().potionBrewing();
        for (int i = 0; i < recipeIngredients.size(); ++i) {
            brewingItemStacks.set(i, (Object)potionbrewing.mix((ItemStack)brewingItemStacks.get(0), recipeIngredients.get(i).copy()));
        }
        brewingItemStacks.set(0, (Object)ItemStack.EMPTY);
        return MixedIngredients.ofInstances(IngredientComponent.ITEMSTACK, brewingItemStacks);
    }
}

