/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.itemhandler;

import java.util.Comparator;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.ItemStack;

public final class ItemMatch {
    public static final int ANY = 0;
    public static final int ITEM = 1;
    public static final int DATA = 4;
    public static final int STACKSIZE = 8;
    public static final int EXACT = 13;
    public static Comparator<DataComponentMap> DATA_COMPARATOR;

    public static boolean areItemStacksEqual(ItemStack a, ItemStack b, int matchFlags) {
        if (matchFlags == 0) {
            return true;
        }
        boolean item = (matchFlags & 1) > 0;
        boolean nbt = (matchFlags & 4) > 0;
        boolean stackSize = (matchFlags & 8) > 0;
        return a == b || a.isEmpty() && b.isEmpty() || !a.isEmpty() && !b.isEmpty() && (!item || a.getItem() == b.getItem()) && (!stackSize || a.getCount() == b.getCount()) && (!nbt || ItemMatch.areItemStackDataComponentsEqual(a, b));
    }

    public static boolean areItemStackDataComponentsEqual(ItemStack a, ItemStack b) {
        DataComponentMap tagA = a.getComponents();
        DataComponentMap tagB = b.getComponents();
        if (tagA.isEmpty() && tagB.isEmpty()) {
            return true;
        }
        return DATA_COMPARATOR.compare(tagA, tagB) == 0;
    }
}

