/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector3f;

public class VertexData {
    private float posX;
    private float posY;
    private float posZ;
    private float normalX;
    private float normalY;
    private float normalZ;
    private int red;
    private int green;
    private int blue;
    private int alpha;
    private float texU;
    private float texV;
    private int overlayU;
    private int overlayV;
    private int lightU;
    private int lightV;
    private Map<VertexFormatElement, int[]> miscData = new HashMap<VertexFormatElement, int[]>();

    public Vector3f getPos() {
        return new Vector3f(this.posX, this.posY, this.posZ);
    }

    public Vec2 getUV() {
        return new Vec2(this.texU, this.texV);
    }

    public int getBlockLight() {
        return this.lightU >> 4;
    }

    public int getSkyLight() {
        return this.lightV >> 4;
    }

    public VertexData color(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        return this;
    }

    public VertexData pos(float x, float y, float z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        return this;
    }

    public VertexData normal(float x, float y, float z) {
        this.normalX = x;
        this.normalY = y;
        this.normalZ = z;
        return this;
    }

    public VertexData texRaw(float u, float v) {
        this.texU = u;
        this.texV = v;
        return this;
    }

    public VertexData overlay(int u, int v) {
        this.overlayU = u;
        this.overlayV = v;
        return this;
    }

    public VertexData lightRaw(int u, int v) {
        this.lightU = u;
        this.lightV = v;
        return this;
    }

    public VertexData light(int u, int v) {
        return this.lightRaw(u << 4, v << 4);
    }

    public VertexData misc(VertexFormatElement element, int ... data) {
        this.miscData.put(element, data);
        return this;
    }

    public VertexData copy(boolean deepCopy) {
        Map<VertexFormatElement, int[]> miscCopy;
        if (deepCopy) {
            miscCopy = new HashMap<VertexFormatElement, int[]>();
            for (Map.Entry<VertexFormatElement, int[]> entry : this.miscData.entrySet()) {
                miscCopy.put(entry.getKey(), Arrays.copyOf(entry.getValue(), entry.getValue().length));
            }
        } else {
            miscCopy = this.miscData;
        }
        return new VertexData(this.posX, this.posY, this.posZ, this.normalX, this.normalY, this.normalZ, this.red, this.green, this.blue, this.alpha, this.texU, this.texV, this.overlayU, this.overlayV, this.lightU, this.lightV, miscCopy);
    }

    public void write(VertexConsumer consumer) {
        consumer.addVertex(this.posX, this.posY, this.posZ);
        consumer.setColor(this.red, this.green, this.blue, this.alpha);
        consumer.setUv(this.texU, this.texV);
        consumer.setUv1(this.overlayU, this.overlayV);
        consumer.setUv2(this.lightU, this.lightV);
        consumer.setNormal(this.normalX, this.normalY, this.normalZ);
        for (Map.Entry<VertexFormatElement, int[]> entry : this.miscData.entrySet()) {
            consumer.misc(entry.getKey(), entry.getValue());
        }
    }

    public float getPosX() {
        return this.posX;
    }

    public float getPosY() {
        return this.posY;
    }

    public float getPosZ() {
        return this.posZ;
    }

    public float getNormalX() {
        return this.normalX;
    }

    public float getNormalY() {
        return this.normalY;
    }

    public float getNormalZ() {
        return this.normalZ;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public float getTexU() {
        return this.texU;
    }

    public float getTexV() {
        return this.texV;
    }

    public int getOverlayU() {
        return this.overlayU;
    }

    public int getOverlayV() {
        return this.overlayV;
    }

    public int getLightU() {
        return this.lightU;
    }

    public int getLightV() {
        return this.lightV;
    }

    public Map<VertexFormatElement, int[]> getMiscData() {
        return this.miscData;
    }

    public String toString() {
        return "VertexData(posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ", normalX=" + this.getNormalX() + ", normalY=" + this.getNormalY() + ", normalZ=" + this.getNormalZ() + ", red=" + this.getRed() + ", green=" + this.getGreen() + ", blue=" + this.getBlue() + ", alpha=" + this.getAlpha() + ", texU=" + this.getTexU() + ", texV=" + this.getTexV() + ", overlayU=" + this.getOverlayU() + ", overlayV=" + this.getOverlayV() + ", lightU=" + this.getLightU() + ", lightV=" + this.getLightV() + ", miscData=" + String.valueOf(this.getMiscData()) + ")";
    }

    public VertexData() {
    }

    public VertexData(float posX, float posY, float posZ, float normalX, float normalY, float normalZ, int red, int green, int blue, int alpha, float texU, float texV, int overlayU, int overlayV, int lightU, int lightV, Map<VertexFormatElement, int[]> miscData) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.normalX = normalX;
        this.normalY = normalY;
        this.normalZ = normalZ;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.texU = texU;
        this.texV = texV;
        this.overlayU = overlayU;
        this.overlayV = overlayV;
        this.lightU = lightU;
        this.lightV = lightV;
        this.miscData = miscData;
    }
}

