/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockstatePredicateParser {
    private static final Type MAP_TYPE = new TypeToken<EnumMap<Direction, Predicate<BlockState>>>(){}.getType();
    private static final Type PREDICATE_TYPE = new TypeToken<Predicate<BlockState>>(){}.getType();
    private final PredicateDeserializer predicateDeserializer = new PredicateDeserializer();
    private final Gson GSON = new GsonBuilder().registerTypeAdapter(PREDICATE_TYPE, (Object)this.predicateDeserializer).registerTypeAdapter(ComparisonType.class, (Object)new ComparisonType.Deserializer()).registerTypeAdapter(MAP_TYPE, type -> new EnumMap(Direction.class)).registerTypeAdapter(PredicateMap.class, (Object)new MapDeserializer()).create();

    @Nullable
    public BiPredicate<Direction, BlockState> parse(JsonElement json) {
        return (BiPredicate)this.GSON.fromJson(json, PredicateMap.class);
    }

    static class PredicateDeserializer
    implements JsonDeserializer<Predicate<BlockState>> {
        private static final Predicate<BlockState> EMPTY = p -> false;
        ThreadLocal<Predicate<BlockState>> defaultPredicate = new ThreadLocal();

        PredicateDeserializer() {
        }

        public Predicate<BlockState> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)obj, (String)"block")));
                if (block == Blocks.AIR) {
                    return EMPTY;
                }
                Composition composition = null;
                if (obj.has("defer")) {
                    if (this.defaultPredicate.get() == null) {
                        throw new JsonParseException("Cannot defer when no default is set!");
                    }
                    try {
                        composition = Composition.valueOf(GsonHelper.getAsString((JsonObject)obj, (String)"defer").toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException e) {
                        throw new JsonSyntaxException(GsonHelper.getAsString((JsonObject)obj, (String)"defer") + " is not a valid defer type.");
                    }
                }
                if (!obj.has("predicate")) {
                    return this.compose(composition, new BlockPredicate(block));
                }
                JsonElement propsEle = obj.get("predicate");
                if (propsEle.isJsonObject()) {
                    return this.compose(composition, this.parsePredicate(block, propsEle.getAsJsonObject(), context));
                }
                if (propsEle.isJsonArray()) {
                    ArrayList<Predicate<BlockState>> predicates = new ArrayList<Predicate<BlockState>>();
                    for (JsonElement ele : propsEle.getAsJsonArray()) {
                        if (ele.isJsonObject()) {
                            predicates.add(this.parsePredicate(block, ele.getAsJsonObject(), context));
                            continue;
                        }
                        throw new JsonSyntaxException("Predicate entry must be a JSON Object. Found: " + String.valueOf(ele));
                    }
                    return this.compose(composition, new PredicateComposition(Composition.AND, predicates));
                }
            } else if (json.isJsonArray()) {
                ArrayList<Predicate<BlockState>> predicates = new ArrayList<Predicate<BlockState>>();
                for (JsonElement ele : json.getAsJsonArray()) {
                    Predicate p = (Predicate)context.deserialize(ele, PREDICATE_TYPE);
                    if (p == EMPTY) continue;
                    predicates.add(p);
                }
                return predicates.isEmpty() ? EMPTY : (predicates.size() == 1 ? (Predicate)predicates.getFirst() : new PredicateComposition(Composition.OR, predicates));
            }
            throw new JsonSyntaxException("Predicate deserialization expects an object or an array. Found: " + String.valueOf(json));
        }

        private Predicate<BlockState> compose(@Nullable Composition composition, @NotNull Predicate<BlockState> child) {
            if (composition == null) {
                return child;
            }
            return composition.composer.apply(this.defaultPredicate.get(), child);
        }

        private Predicate<BlockState> parsePredicate(@NotNull Block block, JsonObject obj, JsonDeserializationContext context) {
            ComparisonType compareFunc = (ComparisonType)((Object)GsonHelper.getAsObject((JsonObject)obj, (String)"compare_func", (Object)((Object)ComparisonType.EQUAL), (JsonDeserializationContext)context, ComparisonType.class));
            obj.remove("compare_func");
            Set entryset = obj.entrySet();
            if (obj.size() != 1) {
                throw new JsonSyntaxException("Predicate entry must define exactly one property->value pair. Found: " + entryset.size());
            }
            String key = (String)((Map.Entry)entryset.iterator().next()).getKey();
            Optional<Property> prop = Optional.ofNullable(block.getStateDefinition().getProperty(key));
            if (prop.isEmpty()) {
                throw new JsonParseException(key + " is not a valid property for blockstate " + String.valueOf(block.defaultBlockState()));
            }
            JsonElement valueEle = obj.get(key);
            if (valueEle.isJsonArray()) {
                return new MultiPropertyPredicate(block, prop.get(), StreamSupport.stream(valueEle.getAsJsonArray().spliterator(), false).map(e -> this.parseValue((Property)prop.get(), (JsonElement)e)).collect(Collectors.toSet()));
            }
            return new PropertyPredicate<Comparable>(block, prop.get(), this.parseValue(prop.get(), valueEle), compareFunc);
        }

        private Comparable parseValue(Property prop, JsonElement ele) {
            String valstr = GsonHelper.convertToString((JsonElement)ele, (String)prop.getName());
            Optional<Object> value = prop.getPossibleValues().stream().filter(v -> prop.getName((Comparable)v).equalsIgnoreCase(valstr)).findFirst();
            if (value.isEmpty()) {
                throw new JsonParseException(valstr + " is not a valid value for property " + String.valueOf(prop));
            }
            return (Comparable)value.get();
        }
    }

    static enum ComparisonType {
        EQUAL("=", i -> i == 0),
        NOT_EQUAL("!=", i -> i != 0),
        GREATER_THAN(">", i -> i > 0),
        LESS_THAN("<", i -> i < 0),
        GREATER_THAN_EQ(">=", i -> i >= 0),
        LESS_THAN_EQ("<=", i -> i <= 0);

        private final String key;
        private final IntPredicate compareFunc;

        private ComparisonType(String key, IntPredicate compareFunc) {
            this.key = key;
            this.compareFunc = compareFunc;
        }

        static class Deserializer
        implements JsonDeserializer<ComparisonType> {
            Deserializer() {
            }

            public ComparisonType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                    Optional<ComparisonType> type = Arrays.stream(ComparisonType.values()).filter(t -> t.key.equals(json.getAsString())).findFirst();
                    if (type.isPresent()) {
                        return type.get();
                    }
                    throw new JsonParseException(String.valueOf(json) + " is not a valid comparison type!");
                }
                throw new JsonSyntaxException("ComparisonType must be a String");
            }
        }
    }

    static class PredicateMap
    implements BiPredicate<Direction, BlockState> {
        private final EnumMap<Direction, Predicate<BlockState>> predicates = new EnumMap(Direction.class);

        @Override
        public boolean test(Direction dir, BlockState state) {
            return this.predicates.get(dir).test(state);
        }
    }

    class MapDeserializer
    implements JsonDeserializer<PredicateMap> {
        MapDeserializer() {
        }

        public PredicateMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                if (obj.has("default")) {
                    BlockstatePredicateParser.this.predicateDeserializer.defaultPredicate.set((Predicate)context.deserialize(obj.get("default"), PREDICATE_TYPE));
                    obj.remove("default");
                }
                PredicateMap ret = new PredicateMap();
                ret.predicates.putAll((Map)context.deserialize((JsonElement)obj, MAP_TYPE));
                for (Direction dir : Direction.values()) {
                    ret.predicates.putIfAbsent(dir, Optional.ofNullable(BlockstatePredicateParser.this.predicateDeserializer.defaultPredicate.get()).orElse(PredicateDeserializer.EMPTY));
                }
                BlockstatePredicateParser.this.predicateDeserializer.defaultPredicate.remove();
                return ret;
            }
            if (json.isJsonArray()) {
                Predicate predicate = (Predicate)context.deserialize(json, PREDICATE_TYPE);
                PredicateMap ret = new PredicateMap();
                for (Direction dir : Direction.values()) {
                    ret.predicates.put(dir, predicate);
                }
                return ret;
            }
            throw new JsonSyntaxException("connectTo must be an object or an array. Found: " + String.valueOf(json));
        }
    }

    private record PredicateComposition(Composition type, List<Predicate<BlockState>> composed) implements Predicate<BlockState>
    {
        @Override
        public boolean test(BlockState t) {
            if (this.type == Composition.AND) {
                for (Predicate<BlockState> p : this.composed) {
                    if (p.test(t)) continue;
                    return false;
                }
                return true;
            }
            for (Predicate<BlockState> p : this.composed) {
                if (!p.test(t)) continue;
                return true;
            }
            return false;
        }
    }

    private record BlockPredicate(Block block) implements Predicate<BlockState>
    {
        @Override
        public boolean test(BlockState t) {
            return t.getBlock() == this.block;
        }
    }

    private record MultiPropertyPredicate<T extends Comparable<T>>(Block block, Property<T> prop, Set<T> validValues) implements Predicate<BlockState>
    {
        @Override
        public boolean test(BlockState t) {
            return t.getBlock() == this.block && this.validValues.contains(t.getValue(this.prop));
        }
    }

    private record PropertyPredicate<T extends Comparable<T>>(Block block, Property<T> prop, T value, ComparisonType type) implements Predicate<BlockState>
    {
        @Override
        public boolean test(BlockState t) {
            return t.getBlock() == this.block && this.type.compareFunc.test(t.getValue(this.prop).compareTo(this.value));
        }
    }

    static enum Composition {
        AND(Predicate::and),
        OR(Predicate::or);

        private final BiFunction<Predicate<BlockState>, Predicate<BlockState>, Predicate<BlockState>> composer;

        private Composition(BiFunction<Predicate<BlockState>, Predicate<BlockState>, Predicate<BlockState>> composer) {
            this.composer = composer;
        }
    }
}

