/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import mcjty.rftoolsbuilder.shapes.Shape;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ShapeCardData(int channel, ShapeCardDimensions dimensions, boolean tagMatching, boolean solid, Set<String> voiding, Shape shape) {
    public static final int MODE_NONE = 0;
    public static final int MODE_CORNER1 = 1;
    public static final int MODE_CORNER2 = 2;
    public static final ShapeCardDimensions DEFAULT_DIMENSIONS = new ShapeCardDimensions(new BlockPos(5, 5, 5), BlockPos.ZERO, 0, null, null);
    public static final ShapeCardData DEFAULT = new ShapeCardData(-1, DEFAULT_DIMENSIONS, false, true, new HashSet<String>(), Shape.SHAPE_BOX);
    public static final Codec<ShapeCardDimensions> DIMENSIONS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("dimension").forGetter(ShapeCardDimensions::dimension), (App)BlockPos.CODEC.fieldOf("offset").forGetter(ShapeCardDimensions::offset), (App)Codec.INT.fieldOf("mode").forGetter(ShapeCardDimensions::mode), (App)BlockPos.CODEC.optionalFieldOf("corner1").forGetter(o -> Optional.ofNullable(o.corner1)), (App)GlobalPos.CODEC.optionalFieldOf("selected").forGetter(o -> Optional.ofNullable(o.selected))).apply((Applicative)instance, (dim, offs, m, c1, sel) -> new ShapeCardDimensions((BlockPos)dim, (BlockPos)offs, (int)m, c1.orElse(null), sel.orElse(null))));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapeCardDimensions> DIMENSIONS_STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ShapeCardDimensions::dimension, (StreamCodec)BlockPos.STREAM_CODEC, ShapeCardDimensions::offset, (StreamCodec)ByteBufCodecs.INT, ShapeCardDimensions::mode, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), s -> Optional.ofNullable(s.corner1()), (StreamCodec)ByteBufCodecs.optional((StreamCodec)GlobalPos.STREAM_CODEC), s -> Optional.ofNullable(s.selected()), (dimension, offset, mode, corner1, selected) -> new ShapeCardDimensions((BlockPos)dimension, (BlockPos)offset, (int)mode, corner1.orElse(null), selected.orElse(null)));
    public static final Codec<ShapeCardData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("channel").forGetter(ShapeCardData::channel), (App)DIMENSIONS_CODEC.fieldOf("dimensions").forGetter(ShapeCardData::dimensions), (App)Codec.BOOL.fieldOf("tagMatching").forGetter(ShapeCardData::tagMatching), (App)Codec.BOOL.optionalFieldOf("solid", (Object)true).forGetter(ShapeCardData::solid), (App)Codec.STRING.listOf().fieldOf("voiding").forGetter(card -> new ArrayList<String>(card.voiding)), (App)Shape.CODEC.fieldOf("shape").forGetter(ShapeCardData::shape)).apply((Applicative)instance, (channel, dimensions, tagMatching, solid, voiding, shape) -> new ShapeCardData((int)channel, (ShapeCardDimensions)dimensions, (boolean)tagMatching, (boolean)solid, (Set<String>)new HashSet<String>((Collection<String>)voiding), (Shape)((Object)((Object)shape)))));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapeCardData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ShapeCardData::channel, DIMENSIONS_STREAM_CODEC, ShapeCardData::dimensions, (StreamCodec)ByteBufCodecs.BOOL, ShapeCardData::tagMatching, (StreamCodec)ByteBufCodecs.BOOL, ShapeCardData::solid, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), s -> new ArrayList<String>(s.voiding), Shape.STREAM_CODEC, ShapeCardData::shape, (channel, dimensions, tagMatching, solid, voiding, shape) -> new ShapeCardData((int)channel, (ShapeCardDimensions)dimensions, (boolean)tagMatching, (boolean)solid, (Set<String>)new HashSet<String>((Collection<String>)voiding), (Shape)((Object)shape)));

    public ShapeCardData withChannel(int channel) {
        return new ShapeCardData(channel, this.dimensions, this.tagMatching, this.solid, this.voiding, this.shape);
    }

    public ShapeCardData withDimension(BlockPos dimension) {
        return new ShapeCardData(this.channel, new ShapeCardDimensions(dimension, this.dimensions.offset, this.dimensions.mode, this.dimensions.corner1, this.dimensions.selected), this.tagMatching, this.solid, this.voiding, this.shape);
    }

    public ShapeCardData withOffset(BlockPos offset) {
        return new ShapeCardData(this.channel, new ShapeCardDimensions(this.dimensions.dimension, offset, this.dimensions.mode, this.dimensions.corner1, this.dimensions.selected), this.tagMatching, this.solid, this.voiding, this.shape);
    }

    public ShapeCardData withMode(int mode) {
        return new ShapeCardData(this.channel, new ShapeCardDimensions(this.dimensions.dimension, this.dimensions.offset, mode, this.dimensions.corner1, this.dimensions.selected), this.tagMatching, this.solid, this.voiding, this.shape);
    }

    public ShapeCardData withCorner(BlockPos corner) {
        return new ShapeCardData(this.channel, new ShapeCardDimensions(this.dimensions.dimension, this.dimensions.offset, this.dimensions.mode, corner, this.dimensions.selected), this.tagMatching, this.solid, this.voiding, this.shape);
    }

    public ShapeCardData withSelected(GlobalPos selected) {
        return new ShapeCardData(this.channel, new ShapeCardDimensions(this.dimensions.dimension, this.dimensions.offset, this.dimensions.mode, this.dimensions.corner1, selected), this.tagMatching, this.solid, this.voiding, this.shape);
    }

    public ShapeCardData withTagMatching(boolean tagMatching) {
        return new ShapeCardData(this.channel, this.dimensions, tagMatching, this.solid, this.voiding, this.shape);
    }

    public ShapeCardData withSolid(boolean solid) {
        return new ShapeCardData(this.channel, this.dimensions, this.tagMatching, solid, this.voiding, this.shape);
    }

    public ShapeCardData withShape(Shape shape) {
        return new ShapeCardData(this.channel, this.dimensions, this.tagMatching, this.solid, this.voiding, shape);
    }

    public ShapeCardData addVoiding(String voiding) {
        HashSet<String> newVoiding = new HashSet<String>(this.voiding);
        newVoiding.add(voiding);
        return new ShapeCardData(this.channel, this.dimensions, this.tagMatching, this.solid, newVoiding, this.shape);
    }

    public ShapeCardData withVoiding(Set<String> voiding) {
        return new ShapeCardData(this.channel, this.dimensions, this.tagMatching, this.solid, voiding, this.shape);
    }

    public record ShapeCardDimensions(BlockPos dimension, BlockPos offset, int mode, BlockPos corner1, GlobalPos selected) {
    }
}

