/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.clickmachine.util;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.FakePlayer;

public class FakePlayerUtil {
    public static UsefulFakePlayer createPlayer(Level world, GameProfile profile) {
        return new UsefulFakePlayer(world, profile);
    }

    public static void setupFakePlayerForUse(UsefulFakePlayer player, BlockPos pos, Direction direction, ItemStack toHold, boolean sneaking) {
        float pitch;
        player.getInventory().items.set(player.getInventory().selected, (Object)toHold);
        float f = direction == Direction.UP ? -90.0f : (pitch = direction == Direction.DOWN ? 90.0f : 0.0f);
        float yaw = direction == Direction.SOUTH ? 0.0f : (direction == Direction.WEST ? 90.0f : (direction == Direction.NORTH ? 180.0f : -90.0f));
        Vec3i sideVec = direction.getNormal();
        Direction.Axis a = direction.getAxis();
        Direction.AxisDirection ad = direction.getAxisDirection();
        double x = a == Direction.Axis.X && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.getX() / 1.9;
        double y = 0.5 + (double)sideVec.getY() / 1.9;
        double z = a == Direction.Axis.Z && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.getZ() / 1.9;
        player.moveTo((double)pos.getX() + x, (double)pos.getY() + y - (double)player.getEyeHeight(), (double)pos.getZ() + z, yaw, pitch);
        if (!toHold.isEmpty()) {
            ItemAttributeModifiers modifiers = toHold.getAttributeModifiers();
            modifiers.forEach(EquipmentSlot.MAINHAND, (attr, modif) -> {
                AttributeInstance inst = player.getAttribute((Holder)attr);
                if (inst != null) {
                    inst.addOrUpdateTransientModifier(modif);
                }
            });
        }
        player.setShiftKeyDown(sneaking);
    }

    public static void cleanupFakePlayerFromUse(UsefulFakePlayer player, ItemStack resultStack, ItemStack oldStack, Consumer<ItemStack> stackCallback) {
        if (!oldStack.isEmpty()) {
            ItemAttributeModifiers modifiers = oldStack.getAttributeModifiers();
            modifiers.forEach(EquipmentSlot.MAINHAND, (attr, modif) -> {
                AttributeInstance inst = player.getAttribute((Holder)attr);
                if (inst != null) {
                    inst.removeModifier(modif);
                }
            });
        }
        player.getInventory().items.set(player.getInventory().selected, (Object)ItemStack.EMPTY);
        stackCallback.accept(resultStack);
        if (!player.getInventory().isEmpty()) {
            player.getInventory().dropAll();
        }
        player.setShiftKeyDown(false);
    }

    public static ItemStack rightClickInDirection(UsefulFakePlayer player, Level world, BlockPos pos, Direction side, BlockState sourceState) {
        InteractionResult type;
        BlockPos blockpos;
        BlockState state;
        HitResult toUse = FakePlayerUtil.rayTrace(player, world, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE));
        if (toUse == null) {
            return player.getMainHandItem();
        }
        ItemStack itemstack = player.getMainHandItem();
        if (toUse.getType() == HitResult.Type.ENTITY) {
            if (FakePlayerUtil.processUseEntity(player, world, ((EntityHitResult)toUse).getEntity(), toUse, InteractionType.INTERACT_AT)) {
                return player.getMainHandItem();
            }
            if (FakePlayerUtil.processUseEntity(player, world, ((EntityHitResult)toUse).getEntity(), null, InteractionType.INTERACT)) {
                return player.getMainHandItem();
            }
        } else if (toUse.getType() == HitResult.Type.BLOCK && (state = world.getBlockState(blockpos = ((BlockHitResult)toUse).getBlockPos())) != sourceState && !state.isAir() && (type = player.gameMode.useItemOn((ServerPlayer)player, world, itemstack, InteractionHand.MAIN_HAND, (BlockHitResult)toUse)) == InteractionResult.SUCCESS) {
            return player.getMainHandItem();
        }
        if (toUse == null || toUse.getType() == HitResult.Type.MISS) {
            for (int i = 1; i <= 5; ++i) {
                state = world.getBlockState(pos.relative(side, i));
                if (state == sourceState || state.isAir()) continue;
                player.gameMode.useItemOn((ServerPlayer)player, world, itemstack, InteractionHand.MAIN_HAND, (BlockHitResult)toUse);
                return player.getMainHandItem();
            }
        }
        if (itemstack.isEmpty() && (toUse == null || toUse.getType() == HitResult.Type.MISS)) {
            CommonHooks.onEmptyClick((Player)player, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        if (!itemstack.isEmpty()) {
            player.gameMode.useItem((ServerPlayer)player, world, itemstack, InteractionHand.MAIN_HAND);
        }
        return player.getMainHandItem();
    }

    public static ItemStack leftClickInDirection(UsefulFakePlayer player, Level world, BlockPos pos, Direction side, BlockState sourceState) {
        BlockPos blockpos;
        BlockState state;
        HitResult toUse = FakePlayerUtil.rayTrace(player, world, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE));
        if (toUse == null) {
            return player.getMainHandItem();
        }
        if (toUse.getType() == HitResult.Type.ENTITY) {
            if (FakePlayerUtil.processUseEntity(player, world, ((EntityHitResult)toUse).getEntity(), null, InteractionType.ATTACK)) {
                return player.getMainHandItem();
            }
        } else if (toUse.getType() == HitResult.Type.BLOCK && (state = world.getBlockState(blockpos = ((BlockHitResult)toUse).getBlockPos())) != sourceState && !state.isAir()) {
            player.gameMode.handleBlockBreakAction(blockpos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, ((BlockHitResult)toUse).getDirection(), player.level().getMaxBuildHeight(), 0);
            return player.getMainHandItem();
        }
        if (toUse == null || toUse.getType() == HitResult.Type.MISS) {
            for (int i = 1; i <= 5; ++i) {
                state = world.getBlockState(pos.relative(side, i));
                if (state == sourceState || state.isAir()) continue;
                player.gameMode.handleBlockBreakAction(pos.relative(side, i), ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, side.getOpposite(), player.level().getMaxBuildHeight(), 0);
                return player.getMainHandItem();
            }
        }
        return player.getMainHandItem();
    }

    public static HitResult traceEntities(UsefulFakePlayer player, Vec3 base, Vec3 target, Level world) {
        Entity pointedEntity = null;
        EntityHitResult result = null;
        Vec3 vec3d3 = null;
        AABB search = new AABB(base.x, base.y, base.z, target.x, target.y, target.z).inflate(0.5, 0.5, 0.5);
        List list = world.getEntities((Entity)player, search, entity -> EntitySelector.NO_SPECTATORS.test(entity) && entity != null && entity.isPickable());
        double d2 = 5.0;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AABB aabb = entity1.getBoundingBox().inflate((double)entity1.getPickRadius());
            Optional optVec = aabb.clip(base, target);
            if (aabb.contains(base)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                vec3d3 = optVec.orElse(base);
                d2 = 0.0;
                continue;
            }
            if (!optVec.isPresent() || !((d3 = base.distanceTo((Vec3)optVec.get())) < d2) && d2 != 0.0) continue;
            if (entity1.getRootVehicle() == player.getRootVehicle() && !entity1.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                vec3d3 = (Vec3)optVec.get();
                continue;
            }
            pointedEntity = entity1;
            vec3d3 = (Vec3)optVec.get();
            d2 = d3;
        }
        if (pointedEntity != null && base.distanceTo(vec3d3) > 5.0) {
            pointedEntity = null;
            result = BlockHitResult.miss(vec3d3, null, (BlockPos)BlockPos.containing(vec3d3));
        }
        if (pointedEntity != null) {
            result = new EntityHitResult(pointedEntity, vec3d3);
        }
        return result;
    }

    public static boolean processUseEntity(UsefulFakePlayer player, Level world, Entity entity, @Nullable HitResult result, InteractionType action) {
        if (entity != null && player.distanceToSqr(entity) < 36.0) {
            if (action == InteractionType.INTERACT) {
                return player.interactOn(entity, InteractionHand.MAIN_HAND) == InteractionResult.SUCCESS;
            }
            if (action == InteractionType.INTERACT_AT) {
                if (CommonHooks.onInteractEntityAt((Player)player, (Entity)entity, (Vec3)result.getLocation(), (InteractionHand)InteractionHand.MAIN_HAND) != null) {
                    return false;
                }
                return entity.interactAt((Player)player, result.getLocation(), InteractionHand.MAIN_HAND) == InteractionResult.SUCCESS;
            }
            if (action == InteractionType.ATTACK) {
                if (entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity instanceof Arrow || entity == player) {
                    return false;
                }
                player.attack(entity);
                return true;
            }
        }
        return false;
    }

    public static HitResult rayTrace(UsefulFakePlayer player, Level level, double reachDist) {
        HitResult toUse;
        Vec3 base = new Vec3(player.getX(), player.getEyeY(), player.getZ());
        Vec3 look = player.getLookAngle();
        Vec3 target = base.add(look.x * reachDist, look.y * reachDist, look.z * reachDist);
        BlockHitResult trace = level.clip(new ClipContext(base, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        HitResult traceEntity = FakePlayerUtil.traceEntities(player, base, target, level);
        Object object = toUse = trace == null ? traceEntity : trace;
        if (trace != null && traceEntity != null) {
            double d1 = trace.getLocation().distanceTo(base);
            double d2 = traceEntity.getLocation().distanceTo(base);
            toUse = traceEntity.getType() == HitResult.Type.ENTITY && d1 > d2 ? traceEntity : trace;
        }
        return toUse;
    }

    public static class UsefulFakePlayer
    extends FakePlayer {
        public UsefulFakePlayer(Level world, GameProfile name) {
            super((ServerLevel)world, name);
        }

        public void initInventoryMenu() {
        }

        public void openHorseInventory(AbstractHorse horse, Container container) {
        }

        public OptionalInt openMenu(MenuProvider p_9033_) {
            return OptionalInt.empty();
        }

        public float getAttackStrengthScale(float adjustTicks) {
            return 1.0f;
        }

        public Entity changeDimension(DimensionTransition transition) {
            return null;
        }
    }

    public static enum InteractionType {
        INTERACT,
        INTERACT_AT,
        ATTACK;

    }
}

