/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.clickmachine.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.clickmachine.gui.ClickMachineMenu;
import dev.shadowsoffire.clickmachine.gui.ClickMachineScreen;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ClickerCheckboxButton
extends AbstractButton {
    private static final ResourceLocation CHECKBOX_SELECTED_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/checkbox_selected_highlighted");
    private static final ResourceLocation CHECKBOX_SELECTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/checkbox_selected");
    private static final ResourceLocation CHECKBOX_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/checkbox_highlighted");
    private static final ResourceLocation CHECKBOX_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/checkbox");
    protected final ClickMachineScreen gui;
    protected final int index;
    protected final BooleanSupplier selected;

    public ClickerCheckboxButton(ClickMachineScreen gui, int x, int y, int width, int height, Component title, int index, BooleanSupplier selected) {
        super(x, y, width, height, title);
        this.gui = gui;
        this.index = index;
        this.selected = selected;
    }

    public void onPress() {
        Minecraft.getInstance().gameMode.handleInventoryButtonClick(((ClickMachineMenu)this.gui.getMenu()).containerId, this.index - 1);
    }

    public boolean isFocused() {
        return super.isHovered() || super.isFocused();
    }

    public boolean isSelected() {
        return this.selected.getAsBoolean();
    }

    public void renderWidget(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.enableDepthTest();
        Font font = minecraft.font;
        gfx.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ResourceLocation sprite = this.isSelected() ? (this.isFocused() ? CHECKBOX_SELECTED_HIGHLIGHTED_SPRITE : CHECKBOX_SELECTED_SPRITE) : (this.isFocused() ? CHECKBOX_HIGHLIGHTED_SPRITE : CHECKBOX_SPRITE);
        gfx.blitSprite(sprite, this.getX(), this.getY(), this.width, this.height);
        gfx.drawString(font, this.getMessage().getString(), this.getX() + 24, this.getY() + (this.height - 8) / 2, 0x404040, false);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

