/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.clickmachine.block;

import com.mojang.authlib.GameProfile;
import dev.shadowsoffire.clickmachine.ClickMachine;
import dev.shadowsoffire.clickmachine.ClickMachineConfig;
import dev.shadowsoffire.clickmachine.block.ClickMachineBlock;
import dev.shadowsoffire.clickmachine.util.FakePlayerUtil;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.ModifiableEnergyStorage;
import dev.shadowsoffire.placebo.menu.SimpleDataSlots;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ClickMachineTile
extends BlockEntity
implements Consumer<ItemStack>,
TickingBlockEntity,
SimpleDataSlots.IDataAutoRegister {
    public static final GameProfile DEFAULT_CLICKER = new GameProfile(UUID.fromString("36f373ac-29ef-4150-b664-e7e6006efcd8"), "[The Click Machine]");
    protected final SimpleDataSlots data = new SimpleDataSlots();
    protected ItemStackHandler held;
    protected ModifiableEnergyStorage power = new ModifiableEnergyStorage(ClickMachineConfig.maxPowerStorage);
    protected int speedIdx = 0;
    protected boolean sneak = false;
    protected boolean rightClick = true;
    protected int counter = 0;
    protected transient GameProfile profile;
    protected transient FakePlayerUtil.UsefulFakePlayer player;
    static final String tagUUID = "uuid";
    static final String tagName = "name";
    static final String tagCounter = "counter";
    static final String tagSpeed = "speed_index";
    static final String tagSneak = "sneak";
    static final String tagRightClick = "right_click";
    static final String tagHandler = "inv";
    static final String tagEnergy = "fe";

    public ClickMachineTile(BlockPos pos, BlockState state) {
        super(ClickMachine.CLICK_MACHINE_TILE, pos, state);
        this.held = new ItemStackHandler(this, 1){

            public boolean isItemValid(int slot, ItemStack stack) {
                return !ClickMachineConfig.blacklistedItems.contains(stack.getItem());
            }
        };
        this.data.addEnergy(this.power);
        this.data.addData(() -> this.speedIdx, v -> {
            this.speedIdx = v;
        });
        this.data.addData(() -> this.sneak, v -> {
            this.sneak = v;
        });
        this.data.addData(() -> this.rightClick, v -> {
            this.rightClick = v;
        });
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.player == null) {
            this.player = FakePlayerUtil.createPlayer(level, this.profile != null ? this.profile : DEFAULT_CLICKER);
        }
        if (!level.hasNeighborSignal(this.worldPosition)) {
            int use;
            int n = use = ClickMachineConfig.usesRF ? ClickMachineConfig.powerPerSpeed[this.getSpeedIndex()] : 0;
            if (this.power.extractEnergy(use, true) == use) {
                this.power.extractEnergy(use, false);
                if (this.counter++ % this.getSpeed() == 0) {
                    Direction facing = (Direction)level.getBlockState(this.worldPosition).getValue((Property)ClickMachineBlock.FACING);
                    FakePlayerUtil.setupFakePlayerForUse(this.getPlayer(), this.worldPosition, facing, this.held.getStackInSlot(0).copy(), this.sneak);
                    ItemStack result = this.held.getStackInSlot(0);
                    result = this.rightClick ? FakePlayerUtil.rightClickInDirection(this.getPlayer(), this.level, this.worldPosition, facing, level.getBlockState(this.worldPosition)) : FakePlayerUtil.leftClickInDirection(this.getPlayer(), this.level, this.worldPosition, facing, level.getBlockState(this.worldPosition));
                    FakePlayerUtil.cleanupFakePlayerFromUse(this.getPlayer(), result, this.held.getStackInSlot(0), this);
                    this.setChanged();
                }
            }
            if (!((Boolean)state.getValue((Property)ClickMachineBlock.ACTIVE)).booleanValue()) {
                level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)ClickMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
            }
        } else if (((Boolean)state.getValue((Property)ClickMachineBlock.ACTIVE)).booleanValue()) {
            level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)ClickMachineBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
        this.player.getCooldowns().tick();
    }

    public void setPlayer(Player player) {
        this.profile = player.getGameProfile();
        this.setChanged();
    }

    FakePlayerUtil.UsefulFakePlayer getPlayer() {
        return this.player;
    }

    public IItemHandler getHandler() {
        return this.held;
    }

    public IEnergyStorage getEnergy() {
        return this.power;
    }

    public int getSpeed() {
        return ClickMachineConfig.speeds[this.getSpeedIndex()];
    }

    public int getSpeedIndex() {
        return this.speedIdx;
    }

    public void setSpeedIndex(int speedIdx) {
        this.speedIdx = speedIdx;
        this.setChanged();
    }

    public boolean isSneaking() {
        return this.sneak;
    }

    public void setSneaking(boolean sneak) {
        this.sneak = sneak;
        this.setChanged();
    }

    public boolean isRightClicking() {
        return this.rightClick;
    }

    public void setRightClicking(boolean rightClick) {
        this.rightClick = rightClick;
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.saveAdditional(tag, regs);
        if (this.profile != null) {
            tag.putUUID(tagUUID, this.profile.getId());
            tag.putString(tagName, this.profile.getName());
        }
        tag.put(tagHandler, (Tag)this.held.serializeNBT(regs));
        tag.putInt(tagCounter, this.counter % this.getSpeed());
        this.writeSyncData(tag);
    }

    CompoundTag writeSyncData(CompoundTag tag) {
        tag.putInt(tagSpeed, this.getSpeedIndex());
        tag.putBoolean(tagSneak, this.sneak);
        tag.putBoolean(tagRightClick, this.rightClick);
        tag.putInt(tagEnergy, this.power.getEnergyStored());
        return tag;
    }

    void readSyncData(CompoundTag tag) {
        this.setSpeedIndex(tag.getInt(tagSpeed));
        this.sneak = tag.getBoolean(tagSneak);
        this.rightClick = tag.getBoolean(tagRightClick);
        this.setPower(tag.getInt(tagEnergy));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.loadAdditional(tag, regs);
        if (tag.contains(tagUUID) && tag.contains(tagName)) {
            this.profile = new GameProfile(tag.getUUID(tagUUID), tag.getString(tagName));
        }
        if (tag.contains(tagHandler)) {
            this.held.deserializeNBT(regs, tag.getCompound(tagHandler));
        }
        this.counter = tag.getInt(tagCounter);
        this.readSyncData(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (be, regs) -> ((ClickMachineTile)be).writeSyncData(new CompoundTag()));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider regs) {
        this.readSyncData(pkt.getTag());
    }

    public int getPower() {
        return this.power.getEnergyStored();
    }

    public void setPower(int energy) {
        this.power.extractEnergy(this.power.getMaxEnergyStored(), false);
        this.power.receiveEnergy(energy, false);
        this.setChanged();
    }

    @Override
    public void accept(ItemStack s) {
        this.held.setStackInSlot(0, s);
    }

    public void registerSlots(Consumer<DataSlot> consumer) {
        this.data.register(consumer);
    }
}

