/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.clickmachine.block;

import dev.shadowsoffire.clickmachine.block.ClickMachineTile;
import dev.shadowsoffire.clickmachine.gui.ClickMachineMenu;
import dev.shadowsoffire.placebo.block_entity.TickingEntityBlock;
import dev.shadowsoffire.placebo.menu.MenuUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class ClickMachineBlock
extends Block
implements TickingEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public ClickMachineBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(5.0f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ClickMachineTile(pPos, pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ACTIVE});
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)direction.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity te = world.getBlockEntity(pos);
        if (!world.isClientSide && te instanceof ClickMachineTile && placer instanceof Player) {
            ((ClickMachineTile)te).setPlayer((Player)placer);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Player placer = context.getPlayer();
        Direction face = placer.getDirection().getOpposite();
        if (placer.getXRot() > 50.0f) {
            face = Direction.UP;
        } else if (placer.getXRot() < -50.0f) {
            face = Direction.DOWN;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)face);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return MenuUtil.openGui((Player)player, (BlockPos)pos, ClickMachineMenu::new);
    }

    @Deprecated
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() == this && newState.getBlock() == this) {
            return;
        }
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof ClickMachineTile) {
            ClickMachineBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)((ClickMachineTile)te).held.getStackInSlot(0));
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    @Deprecated
    public int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        BlockEntity te = pLevel.getBlockEntity(pPos);
        if (te instanceof ClickMachineTile) {
            ItemStack i = ((ClickMachineTile)te).held.getStackInSlot(0);
            if (i.isEmpty()) {
                return 0;
            }
            if (i.getMaxStackSize() == 1 && i.isDamageableItem()) {
                return Mth.floor((float)(15.0f * (float)(i.getMaxDamage() - i.getDamageValue()) / (float)i.getMaxDamage()));
            }
            return Mth.floor((float)(15.0f * (float)i.getCount() / (float)i.getMaxStackSize()));
        }
        return 0;
    }
}

