/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.clickmachine;

import dev.shadowsoffire.clickmachine.ClickMachineConfig;
import dev.shadowsoffire.clickmachine.block.ClickMachineBlock;
import dev.shadowsoffire.clickmachine.block.ClickMachineTile;
import dev.shadowsoffire.clickmachine.data.ClickRecipes;
import dev.shadowsoffire.clickmachine.data.LootProvider;
import dev.shadowsoffire.clickmachine.gui.ClickMachineMenu;
import dev.shadowsoffire.clickmachine.util.FakePlayerUtil;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntityType;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.datagen.DataGenBuilder;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import dev.shadowsoffire.placebo.registry.DeferredHelper;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import dev.shadowsoffire.placebo.util.RunnableReloader;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="clickmachine")
public class ClickMachine {
    public static final String MODID = "clickmachine";
    public static final Logger LOG = LogManager.getLogger((String)"clickmachine");
    private static final DeferredHelper R = DeferredHelper.create((String)"clickmachine");
    public static final Holder<Block> CLICK_MACHINE = R.block("click_machine", ClickMachineBlock::new);
    public static final Holder<Item> CLICK_MACHINE_ITEM = R.blockItem("click_machine", CLICK_MACHINE);
    public static final MenuType<ClickMachineMenu> CLICK_MACHINE_MENU = R.menuWithPos("click_machine", ClickMachineMenu::new);
    public static final BlockEntityType<ClickMachineTile> CLICK_MACHINE_TILE = R.tickingBlockEntity("click_machine", ClickMachineTile::new, TickingBlockEntityType.TickSide.SERVER, new Holder[]{CLICK_MACHINE});

    public ClickMachine(IEventBus bus) {
        bus.register((Object)this);
        bus.register((Object)R);
        NeoForge.EVENT_BUS.register((Object)new GameBusEvents(this));
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> TabFillingRegistry.registerSimple((ResourceKey)CreativeModeTabs.REDSTONE_BLOCKS, (ItemLike[])new ItemLike[]{(ItemLike)CLICK_MACHINE_ITEM.value()}));
        PayloadHelper.registerPayload((PayloadProvider)new ClickMachineConfig.ConfigPayload.Provider());
    }

    @SubscribeEvent
    public void data(GatherDataEvent e) {
        DataGenBuilder.create((String[])new String[]{MODID}).provider(ClickRecipes::new).provider(LootProvider::create).build(e);
    }

    @SubscribeEvent
    public void caps(RegisterCapabilitiesEvent e) {
        e.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, CLICK_MACHINE_TILE, (be, ctx) -> be.getEnergy());
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, CLICK_MACHINE_TILE, (be, ctx) -> be.getHandler());
    }

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private class GameBusEvents {
        private GameBusEvents(ClickMachine clickMachine) {
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void blockJoin(EntityJoinLevelEvent e) {
            if (e.getEntity() instanceof FakePlayerUtil.UsefulFakePlayer) {
                e.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void dims(EntityEvent.Size e) {
            if (e.getEntity() instanceof FakePlayerUtil.UsefulFakePlayer) {
                e.setNewSize(e.getNewSize().withEyeHeight(0.0f));
            }
        }

        @SubscribeEvent
        public void reloads(AddReloadListenerEvent e) {
            e.addListener((PreparableReloadListener)RunnableReloader.of(() -> ClickMachineConfig.init(new Configuration(ClickMachine.MODID))));
        }

        @SubscribeEvent
        public void sync(OnDatapackSyncEvent e) {
            if (e.getPlayer() != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)e.getPlayer(), (CustomPacketPayload)new ClickMachineConfig.ConfigPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ClickMachineConfig.ConfigPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

