/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.controller;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.XNet;
import mcjty.xnet.client.ConnectorInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ChannelInfo {
    public static final int MAX_CHANNELS = 8;
    private final IChannelType type;
    private final IChannelSettings channelSettings;
    private String channelName = "";
    private boolean enabled = true;
    private final Map<SidedConsumer, ConnectorInfo> connectors = new HashMap<SidedConsumer, ConnectorInfo>();
    public static final ChannelInfo EMPTY = new ChannelInfo(XNet.setup.noneChannelType);
    public static final Codec<IChannelSettings> CHANNEL_SETTINGS_CODEC = Codec.lazyInitialized(() -> Codec.STRING.dispatch("type", e -> e.getType().getID(), s -> XNet.xNetApi.findType((String)s).getCodec()));
    public static final Codec<ChannelInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CHANNEL_SETTINGS_CODEC.fieldOf("settings").forGetter(ChannelInfo::getChannelSettings), (App)Codec.STRING.optionalFieldOf("name", (Object)"").forGetter(ChannelInfo::getChannelName), (App)Codec.BOOL.fieldOf("enabled").forGetter(ChannelInfo::isEnabled), (App)Codec.list(ConnectorInfo.CODEC).fieldOf("connectors").forGetter(info -> new ArrayList<ConnectorInfo>(info.connectors.values()))).apply((Applicative)instance, ChannelInfo::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChannelInfo> STREAM_CODEC = StreamCodec.of((buf, info) -> {
        buf.writeUtf(info.type.getID());
        StreamCodec streamCodec = info.type.getStreamCodec();
        StreamCodec connectorStreamCodec = info.type.getConnectorStreamCodec();
        streamCodec.encode(buf, (Object)info.channelSettings);
        buf.writeUtf(info.getChannelName());
        buf.writeBoolean(info.isEnabled());
        buf.writeInt(info.connectors.size());
        for (ConnectorInfo connectorInfo : info.connectors.values()) {
            ConnectorInfo.STREAM_CODEC.encode(buf, (Object)connectorInfo);
        }
    }, buf -> {
        String id = buf.readUtf(Short.MAX_VALUE);
        IChannelType type = XNet.xNetApi.findType(id);
        IChannelSettings settings = (IChannelSettings)type.getStreamCodec().decode(buf);
        String name = buf.readUtf(Short.MAX_VALUE);
        boolean enabled = buf.readBoolean();
        ArrayList<ConnectorInfo> connectors = new ArrayList<ConnectorInfo>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            connectors.add((ConnectorInfo)ConnectorInfo.STREAM_CODEC.decode(buf));
        }
        return new ChannelInfo(settings, name, enabled, connectors);
    });

    public ChannelInfo(IChannelType type) {
        this.type = type;
        this.channelSettings = type.createChannel();
        this.enabled = !this.isEmpty();
    }

    public ChannelInfo(IChannelSettings settings, String name, boolean enabled, List<ConnectorInfo> connectors) {
        this.type = settings.getType();
        this.channelSettings = settings;
        this.channelName = name;
        this.enabled = enabled;
        for (ConnectorInfo connector : connectors) {
            this.connectors.put(connector.getId(), connector);
        }
    }

    public boolean isEmpty() {
        return this.type == XNet.setup.noneChannelType;
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName == null ? "" : this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public IChannelType getType() {
        return this.type;
    }

    public IChannelSettings getChannelSettings() {
        return this.channelSettings;
    }

    public Map<SidedConsumer, ConnectorInfo> getConnectors() {
        return this.connectors;
    }

    public ConnectorInfo createConnector(SidedConsumer id, boolean advanced) {
        ConnectorInfo info = new ConnectorInfo(this.type, id, advanced);
        this.connectors.put(id, info);
        return info;
    }
}

