/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.polylib.items.helpers.IDamageBarHelper;
import net.creeperhost.soulshardsrespawn.SSDataComponentType;
import net.creeperhost.soulshardsrespawn.SoulShards;
import net.creeperhost.soulshardsrespawn.api.IShardTier;
import net.creeperhost.soulshardsrespawn.api.ISoulShard;
import net.creeperhost.soulshardsrespawn.api.SoulShardsAPI;
import net.creeperhost.soulshardsrespawn.block.TileEntitySoulCage;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.creeperhost.soulshardsrespawn.core.data.Binding;
import net.creeperhost.soulshardsrespawn.core.data.Tier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ItemSoulShard
extends Item
implements ISoulShard,
IDamageBarHelper {
    public ItemSoulShard() {
        super(new Item.Properties());
    }

    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return InteractionResult.PASS;
        }
        if (state.getBlock() instanceof SpawnerBlock) {
            if (!SoulShards.CONFIG.getBalance().allowSpawnerAbsorption()) {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"chat.soulshards.absorb_disabled"), false);
                return InteractionResult.PASS;
            }
            if (binding.getKills() >= Tier.maxKills) {
                return InteractionResult.PASS;
            }
            if (!(context.getLevel().getBlockEntity(context.getClickedPos()) instanceof SpawnerBlockEntity)) {
                return InteractionResult.FAIL;
            }
            SpawnerBlockEntity mobSpawner = (SpawnerBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos());
            if (mobSpawner == null) {
                return InteractionResult.PASS;
            }
            try {
                ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mobSpawner.getSpawner().getOrCreateDisplayEntity(context.getLevel(), mobSpawner.getBlockPos()).getType());
                if (!SoulShardsAPI.isAllowed(binding.getBoundEntity())) {
                    return InteractionResult.PASS;
                }
                if (entityId == null || binding.getBoundEntity() == null || !binding.getBoundEntity().equals((Object)entityId)) {
                    return InteractionResult.FAIL;
                }
                this.updateBinding(stack, binding.addKills(SoulShards.CONFIG.getBalance().getAbsorptionBonus()));
                context.getLevel().destroyBlock(context.getClickedPos(), false);
                return InteractionResult.SUCCESS;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (state.getBlock() == RegistrarSoulShards.SOUL_CAGE.get()) {
            if (binding.getBoundEntity() == null) {
                return InteractionResult.FAIL;
            }
            TileEntitySoulCage cage = (TileEntitySoulCage)context.getLevel().getBlockEntity(context.getClickedPos());
            if (cage == null) {
                return InteractionResult.PASS;
            }
            ItemStackHandler itemHandler = cage.getInventory();
            if (itemHandler != null && itemHandler.getStackInSlot(0).isEmpty()) {
                ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack.copy(), (boolean)false);
                cage.setChanged();
                cage.setActive(true);
                context.getPlayer().setItemInHand(context.getHand(), ItemStack.EMPTY);
                return InteractionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(itemStack, context);
    }

    public List<ItemStack> fillItemCategory() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack((ItemLike)this));
        for (IShardTier tier : Tier.INDEXED) {
            ItemStack stack = new ItemStack((ItemLike)this);
            Binding binding = new Binding(null, tier.getKillRequirement());
            this.updateBinding(stack, binding);
            items.add(stack);
        }
        return items;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        EntityType entityEntry;
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return;
        }
        if (binding.getBoundEntity() != null && (entityEntry = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(binding.getBoundEntity())) != null) {
            ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityEntry);
            tooltip.add((Component)Component.translatable((String)"tooltip.soulshards.bound", (Object[])new Object[]{resourceLocation.toString()}));
        }
        tooltip.add((Component)Component.translatable((String)"tooltip.soulshards.tier", (Object[])new Object[]{binding.getTier().getIndex()}));
        tooltip.add((Component)Component.translatable((String)"tooltip.soulshards.kills", (Object[])new Object[]{binding.getKills()}));
        if (flag.isAdvanced() && binding.getOwner() != null) {
            tooltip.add((Component)Component.translatable((String)"tooltip.soulshards.owner", (Object[])new Object[]{binding.getOwner().toString()}));
        }
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        Binding binding = this.getBinding(stack);
        return binding != null && binding.getKills() >= Tier.maxKills;
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.getBinding(stack) == null ? 64 : 1;
    }

    public boolean isBarVisible(@Nonnull ItemStack itemStack) {
        Binding binding = this.getBinding(itemStack);
        return SoulShards.CONFIG.getClient().displayDurabilityBar() && binding != null && binding.getKills() < Tier.maxKills;
    }

    public float getWidthForBar(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return 1.0f;
        }
        return 1.0f - (float)binding.getKills() / (float)Tier.maxKills;
    }

    public int getBarWidth(@Nonnull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int getBarColor(@Nonnull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    @Override
    @Nullable
    public Binding getBinding(ItemStack stack) {
        return Binding.fromNBT(stack);
    }

    public void updateBinding(ItemStack stack, Binding binding) {
        stack.set(SSDataComponentType.BOUND_ENTITY, (Object)(binding.getBoundEntity() != null ? binding.getBoundEntity().toString() : ""));
        stack.set(SSDataComponentType.OWNER, (Object)(binding.getOwner() != null ? binding.getOwner().toString() : ""));
        stack.set(SSDataComponentType.KILLS, (Object)binding.getKills());
    }
}

