/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.core.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import java.awt.Point;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

@JsonAdapter(value=Serializer.class)
public class MultiblockPattern {
    public static final MultiblockPattern DEFAULT = new MultiblockPattern(new ItemStack((ItemLike)Items.DIAMOND), new String[]{"OQO", "QGQ", "OQO"}, new Point(1, 1), (Map<Character, Slot>)new HashMap<Character, Slot>(){
        {
            this.put(Character.valueOf('O'), new Slot(Blocks.OBSIDIAN));
            this.put(Character.valueOf('Q'), new Slot(Blocks.QUARTZ_BLOCK));
            this.put(Character.valueOf('G'), new Slot(Blocks.GLOWSTONE));
        }
    });
    private final ItemStack catalyst;
    private final String[] shape;
    private final Point origin;
    private final Map<Character, Slot> definition;

    public MultiblockPattern(ItemStack catalyst, String[] shape, Point origin, Map<Character, Slot> definition) {
        this.catalyst = catalyst;
        this.shape = shape;
        this.origin = origin;
        this.definition = definition;
        this.definition.put(Character.valueOf(' '), new Slot(Blocks.AIR.defaultBlockState()));
        char originChar = shape[origin.y].charAt(origin.x);
        if (originChar == ' ' || definition.get(Character.valueOf(originChar)).test(Blocks.AIR.defaultBlockState())) {
            throw new IllegalStateException("Origin point cannot be blank space.");
        }
        int lineLength = shape[0].length();
        for (String line : shape) {
            if (line.length() != lineLength) {
                throw new IllegalStateException("All lines in the shape must be the same size.");
            }
            for (char letter : line.toCharArray()) {
                if (definition.get(Character.valueOf(letter)) != null) continue;
                throw new IllegalStateException(letter + " is not defined.");
            }
        }
    }

    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    public InteractionResultHolder<Set<BlockPos>> match(Level world, BlockPos originBlock) {
        HashSet matched = Sets.newHashSet();
        for (int y = 0; y < this.shape.length; ++y) {
            String line = this.shape[y];
            for (int x = 0; x < line.length(); ++x) {
                BlockPos offset = originBlock.offset(x - this.origin.x, 0, y - this.origin.y);
                BlockState state = world.getBlockState(offset);
                if (!this.definition.get(Character.valueOf(line.charAt(x))).test(state)) {
                    return new InteractionResultHolder(InteractionResult.FAIL, Collections.emptySet());
                }
                matched.add(offset);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)matched);
    }

    public boolean isOriginBlock(BlockState state) {
        Slot slot = this.definition.get(Character.valueOf(this.shape[this.origin.y].charAt(this.origin.x)));
        return slot.test(state);
    }

    public static class Slot
    implements Predicate<BlockState> {
        @JsonAdapter(value=SerializerBlockState.class)
        private final Set<BlockState> blocks;

        public Slot(BlockState ... states) {
            this.blocks = Sets.newHashSet((Object[])states);
        }

        public Slot(Block block) {
            this((BlockState[])block.getStateDefinition().getPossibleStates().toArray((Object[])new BlockState[0]));
        }

        @Override
        public boolean test(BlockState state) {
            return this.blocks.contains(state);
        }
    }

    public static class SerializerBlockState
    implements JsonDeserializer<Set<BlockState>> {
        public Set<BlockState> deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashSet states = Sets.newHashSet();
            for (JsonElement entry : element.getAsJsonArray()) {
                if (!entry.isJsonPrimitive()) {
                    throw new JsonParseException("Found invalid block when parsing SoulShards multiblock file: " + String.valueOf(entry) + ", Expected String");
                }
                for (BlockState possible : ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)entry.getAsString()))).getStateDefinition().getPossibleStates()) {
                    if (possible.getBlock() instanceof SlabBlock && possible.getValue((Property)SlabBlock.TYPE) != SlabType.DOUBLE) continue;
                    states.add(possible);
                }
            }
            return states;
        }
    }

    public static class Serializer
    implements JsonDeserializer<MultiblockPattern> {
        public MultiblockPattern deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            ResourceLocation itemId = ResourceLocation.parse((String)json.getAsJsonObject("catalyst").getAsJsonPrimitive("item").getAsString());
            ItemStack catalyst = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(itemId), 1);
            String[] shape = (String[])context.deserialize((JsonElement)json.getAsJsonArray("shape"), String[].class);
            Point origin = (Point)context.deserialize((JsonElement)json.getAsJsonObject("origin"), Point.class);
            Map definition = (Map)context.deserialize((JsonElement)json.getAsJsonObject("definition"), new TypeToken<Map<Character, Slot>>(this){}.getType());
            return new MultiblockPattern(catalyst, shape, origin, definition);
        }
    }
}

