/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.core;

import java.util.Set;
import javax.annotation.Nonnull;
import net.creeperhost.soulshardsrespawn.SoulShards;
import net.creeperhost.soulshardsrespawn.api.BindingEvent;
import net.creeperhost.soulshardsrespawn.api.ISoulWeapon;
import net.creeperhost.soulshardsrespawn.api.SoulShardsAPI;
import net.creeperhost.soulshardsrespawn.core.ConfigSoulShards;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.creeperhost.soulshardsrespawn.core.data.Binding;
import net.creeperhost.soulshardsrespawn.core.data.MultiblockPattern;
import net.creeperhost.soulshardsrespawn.core.data.Tier;
import net.creeperhost.soulshardsrespawn.item.ItemSoulShard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@EventBusSubscriber(modid="soulshards")
public class EventHandler {
    @SubscribeEvent
    public static void onEntityKill(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        if (!SoulShards.CONFIG.getBalance().allowFakePlayers() && event.getSource().getEntity() instanceof FakePlayer) {
            return;
        }
        ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType());
        if (!SoulShardsAPI.isAllowed(resourceLocation)) {
            return;
        }
        if (!SoulShards.CONFIG.getBalance().allowBossSpawns() && event.getEntity().getType().is(Tags.EntityTypes.BOSSES)) {
            return;
        }
        if (!SoulShards.CONFIG.getBalance().countCageBornForShard() && event.getEntity().getPersistentData().getBoolean("cageBorn")) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BindingEvent.GetEntityName getEntityName = new BindingEvent.GetEntityName(event.getEntity());
            NeoForge.EVENT_BUS.post((Event)getEntityName);
            ResourceLocation entityId = getEntityName.getEntityId() == null ? BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType()) : getEntityName.getEntityId();
            ItemStack shardItem = EventHandler.getFirstShard(player, entityId);
            if (shardItem.isEmpty()) {
                return;
            }
            ItemSoulShard soulShard = (ItemSoulShard)shardItem.getItem();
            boolean newItem = false;
            Binding binding = soulShard.getBinding(shardItem);
            if (binding == null) {
                BindingEvent.NewBinding newBinding = new BindingEvent.NewBinding(event.getEntity(), new Binding(null, 0));
                if (shardItem.getCount() > 1) {
                    shardItem = shardItem.split(1);
                    newItem = true;
                }
                binding = (Binding)newBinding.getBinding();
            }
            ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
            int soulsGained = 1 + EnchantmentHelper.getItemEnchantmentLevel(EventHandler.getEnchantment(event.getEntity().level()), (ItemStack)mainHand);
            if (mainHand.getItem() instanceof ISoulWeapon) {
                soulsGained += ((ISoulWeapon)mainHand.getItem()).getSoulBonus(mainHand, player, event.getEntity());
            }
            BindingEvent.GainSouls gainSouls = new BindingEvent.GainSouls(event.getEntity(), binding, soulsGained);
            NeoForge.EVENT_BUS.post((Event)gainSouls);
            if (binding.getBoundEntity() == null) {
                binding.setBoundEntity(entityId);
            }
            if (binding.getOwner() == null) {
                binding.setOwner(player.getGameProfile().getId());
            }
            soulShard.updateBinding(shardItem, binding.addKills(gainSouls.getAmount()));
            if (newItem) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)shardItem);
            }
        }
    }

    public static Holder<Enchantment> getEnchantment(Level level) {
        ResourceKey SOUL_STEALER = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"soulshards", (String)"soul_stealer"));
        return (Holder)((Registry)level.registryAccess().registry(Registries.ENCHANTMENT).get()).getHolder(SOUL_STEALER).get();
    }

    @SubscribeEvent
    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        MultiblockPattern pattern = ConfigSoulShards.getMultiblock();
        ItemStack held = event.getEntity().getItemInHand(event.getHand());
        if (!ItemStack.isSameItem((ItemStack)held, (ItemStack)pattern.getCatalyst())) {
            return;
        }
        BlockState state = event.getLevel().getBlockState(event.getPos());
        if (!pattern.isOriginBlock(state)) {
            return;
        }
        InteractionResultHolder<Set<BlockPos>> matched = pattern.match(event.getLevel(), event.getPos());
        if (matched.getResult() != InteractionResult.SUCCESS) {
            return;
        }
        for (BlockPos pos : (Set)matched.getObject()) {
            event.getLevel().destroyBlock(pos, false);
        }
        held.shrink(1);
        ItemHandlerHelper.giveItemToPlayer((Player)event.getEntity(), (ItemStack)new ItemStack((ItemLike)RegistrarSoulShards.SOUL_SHARD.get()));
    }

    @SubscribeEvent
    public static void onAnvil(AnvilUpdateEvent event) {
        if (!SoulShards.CONFIG.getBalance().allowShardCombination()) {
            return;
        }
        if (event.getLeft().getItem() instanceof ItemSoulShard && event.getRight().getItem() instanceof ItemSoulShard) {
            Binding left = ((ItemSoulShard)event.getLeft().getItem()).getBinding(event.getLeft());
            Binding right = ((ItemSoulShard)event.getRight().getItem()).getBinding(event.getRight());
            if (left == null || right == null) {
                return;
            }
            if (left.getBoundEntity() != null && left.getBoundEntity().equals((Object)right.getBoundEntity())) {
                ItemStack output = new ItemStack((ItemLike)RegistrarSoulShards.SOUL_SHARD.get());
                ((ItemSoulShard)output.getItem()).updateBinding(output, left.addKills(right.getKills()));
                event.setOutput(output);
                event.setCost((long)(left.getTier().getIndex() * 6));
            }
        }
    }

    @SubscribeEvent
    public static void dropExperience(LivingExperienceDropEvent event) {
        if (!SoulShards.CONFIG.getBalance().shouldDropExperience() && event.getEntity().getPersistentData().getBoolean("cageBorn")) {
            event.setCanceled(true);
        }
    }

    @Nonnull
    public static ItemStack getFirstShard(Player player, ResourceLocation entityId) {
        ItemStack shardItem = player.getItemInHand(InteractionHand.OFF_HAND);
        if (shardItem.isEmpty() || !(shardItem.getItem() instanceof ItemSoulShard)) {
            for (int i = 0; i < 9; ++i) {
                shardItem = player.getInventory().getItem(i);
                if (shardItem.isEmpty() || !(shardItem.getItem() instanceof ItemSoulShard)) continue;
                Binding binding = ((ItemSoulShard)shardItem.getItem()).getBinding(shardItem);
                if (binding == null || binding.getBoundEntity() == null) {
                    return shardItem;
                }
                if (!binding.getBoundEntity().equals((Object)entityId) || binding.getKills() >= Tier.maxKills) continue;
                return shardItem;
            }
        } else {
            Binding binding = ((ItemSoulShard)shardItem.getItem()).getBinding(shardItem);
            if (binding == null || binding.getBoundEntity() == null) {
                return shardItem;
            }
            if (binding.getBoundEntity().equals((Object)entityId) && binding.getKills() < Tier.maxKills) {
                return shardItem;
            }
        }
        return ItemStack.EMPTY;
    }
}

