/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.creeperhost.soulshardsrespawn.compat.jei.MultiBlockDrawable;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class MultiblockCategory
implements IRecipeCategory<Recipe> {
    public static final Component TITLE = Component.translatable((String)"jei.soulshards.soul_shard.title");
    public static final RecipeType<Recipe> SOUL_SHARD_CRAFTING = RecipeType.create((String)"soulshards", (String)"soulshardcrafting", Recipe.class);
    private final IGuiHelper iGuiHelper;
    private final IDrawable multiblock;
    private final IDrawable arrowRight;

    public MultiblockCategory(IGuiHelper iGuiHelper) {
        this.iGuiHelper = iGuiHelper;
        IDrawable obsidian = iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.OBSIDIAN));
        IDrawable quartz = iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.QUARTZ_BLOCK));
        IDrawable glowstone = iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.GLOWSTONE));
        this.multiblock = new MultiBlockDrawable(obsidian, glowstone, quartz);
        this.arrowRight = iGuiHelper.drawableBuilder(ResourceLocation.withDefaultNamespace((String)"textures/gui/container/furnace.png"), 176, 14, 24, 17).build();
    }

    @NotNull
    public RecipeType<Recipe> getRecipeType() {
        return SOUL_SHARD_CRAFTING;
    }

    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.iGuiHelper.createBlankDrawable(114, 131);
    }

    @NotNull
    public IDrawable getIcon() {
        return this.iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistrarSoulShards.SOUL_SHARD.get()));
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.multiblock.draw(guiGraphics, 10, 30);
        this.arrowRight.draw(guiGraphics, 60, 30);
        Font font = Minecraft.getInstance().font;
        List craftLabel = font.split((FormattedText)Component.translatable((String)"jei.soulshards.soul_shard.creation", (Object[])new Object[]{String.valueOf(ChatFormatting.DARK_PURPLE) + recipe.getInput().getHoverName().getString() + String.valueOf(ChatFormatting.RESET)}), 200);
        int y = 70;
        for (FormattedCharSequence line : craftLabel) {
            guiGraphics.drawString(font, line, 2, y, 0, false);
            y += 10;
        }
        RenderSystem.disableBlend();
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull Recipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.isInRect(10, 30, 40, 36, mouseX, mouseY)) {
            components.add((Component)Component.literal((String)("4x " + Blocks.OBSIDIAN.getName().getString())));
            components.add((Component)Component.literal((String)("4x " + Blocks.QUARTZ_BLOCK.getName().getString())));
            components.add((Component)Component.literal((String)("1x " + Blocks.GLOWSTONE.getName().getString())));
        }
        return components;
    }

    public boolean isInRect(int x, int y, int xSize, int ySize, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)(x + xSize) && mouseY >= (double)y && mouseY <= (double)(y + ySize);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull Recipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 23, 1).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 30).addItemStack(recipe.getOutput());
    }

    public static class Recipe {
        private final ItemStack input;
        private final ItemStack output;

        public Recipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }
    }
}

