/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.block;

import java.util.HashMap;
import java.util.Map;
import net.creeperhost.soulshardsrespawn.SoulShards;
import net.creeperhost.soulshardsrespawn.api.CageSpawnEvent;
import net.creeperhost.soulshardsrespawn.api.IShardTier;
import net.creeperhost.soulshardsrespawn.block.TileEntitySoulCage;
import net.creeperhost.soulshardsrespawn.core.data.Binding;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.Nullable;

public class SoulSpawnerLogic
extends BaseSpawner {
    private static Map<ResourceLocation, Entity> RENDER_ENTITY_CACHE = new HashMap<ResourceLocation, Entity>();
    private final TileEntitySoulCage tile;
    private double mobRotation;
    private double prevMobRotation;

    public SoulSpawnerLogic(TileEntitySoulCage tile) {
        this.tile = tile;
    }

    public void setEntityId(EntityType<?> p_253682_, @Nullable Level p_254041_, RandomSource p_254221_, BlockPos p_254050_) {
    }

    public void clientTick(Level level, BlockPos pos) {
        if (!this.tile.isActive()) {
            this.prevMobRotation = this.mobRotation;
        } else {
            double d3 = (float)pos.getX() + level.random.nextFloat();
            double d4 = (float)pos.getY() + level.random.nextFloat();
            double d5 = (float)pos.getZ() + level.random.nextFloat();
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d3, d4, d5, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, d3, d4, d5, 0.0, 0.0, 0.0);
            if (this.tile.spawnDelay > 0) {
                --this.tile.spawnDelay;
            }
            this.prevMobRotation = this.mobRotation;
            Binding binding = this.tile.getBinding();
            if (binding != null) {
                double progress = 1.0 - (double)this.tile.spawnDelay / (double)binding.getTier().getCooldown();
                this.mobRotation = (this.mobRotation + progress * 4.5 + 0.5) % 360.0;
            } else {
                this.mobRotation = (this.mobRotation + (double)(1000.0f / ((float)this.tile.spawnDelay + 200.0f))) % 360.0;
            }
        }
    }

    public void serverTick(ServerLevel level, BlockPos pos) {
        if (!this.tile.isActive()) {
            return;
        }
        if (this.tile.spawnDelay == -1) {
            this.resetTimer();
            return;
        }
        if (this.tile.spawnDelay > 0) {
            --this.tile.spawnDelay;
            return;
        }
        Binding binding = this.tile.getBinding();
        IShardTier tier = binding.getTier();
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(binding.getBoundEntity());
        if (type == null) {
            this.resetTimer();
            return;
        }
        boolean spawnedAny = false;
        int successCount = 0;
        for (int i = 0; i < tier.getSpawnAmount() + tier.getIndex() + 3; ++i) {
            LivingEntity entity = (LivingEntity)type.create((Level)level);
            if (entity == null || this.hasReachedSpawnCap(entity)) {
                this.resetTimer();
                return;
            }
            do {
                double spawnX = (double)pos.getX() + (level.random.nextDouble() - level.random.nextDouble()) * 4.0 + 0.5;
                double spawnY = pos.getY() + level.random.nextInt(3) - 1;
                double spawnZ = (double)pos.getZ() + (level.random.nextDouble() - level.random.nextDouble()) * 4.0 + 0.5;
                entity.absMoveTo(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            } while (entity.blockPosition().getX() == this.tile.getBlockPos().getX() && entity.blockPosition().getZ() == this.tile.getBlockPos().getZ());
            entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), level.random.nextFloat() * 360.0f, 0.0f);
            if (this.attemptEntitySpawn(binding, type, entity, level, (float)entity.getX(), (float)entity.getY(), (float)entity.getZ())) {
                entity.getPersistentData().putBoolean("cageBorn", true);
                level.levelEvent(2004, pos, 0);
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.spawnAnim();
                }
                spawnedAny = true;
                ++successCount;
            }
            if (successCount >= tier.getSpawnAmount()) break;
        }
        if (spawnedAny) {
            this.resetTimer();
        }
    }

    public boolean attemptEntitySpawn(Binding binding, EntityType<?> type, LivingEntity entity, ServerLevel level, double x, double y, double z) {
        if (!level.noCollision(type.getSpawnAABB(x, y, z))) {
            return false;
        }
        BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
        if (binding.getTier().checkLight() && !this.canSpawnInLight(entity)) {
            return false;
        }
        int tier = binding.getTier().getIndex();
        if (tier < 5 && !SpawnPlacements.checkSpawnRules(type, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)blockpos, (RandomSource)level.getRandom())) {
            return false;
        }
        CageSpawnEvent cageEvent = new CageSpawnEvent(binding, this.tile.getInventory().getStackInSlot(0), entity);
        if (((CageSpawnEvent)NeoForge.EVENT_BUS.post((Event)cageEvent)).isCanceled()) {
            return false;
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!(tier >= 5 || mob.checkSpawnRules((LevelAccessor)level, MobSpawnType.SPAWNER) && mob.checkSpawnObstruction((LevelReader)level))) {
                return false;
            }
            FinalizeSpawnEvent finalizeEvent = EventHooks.finalizeMobSpawnSpawner((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, (IOwnedSpawner)this, (boolean)true);
            if (finalizeEvent != null && !finalizeEvent.isSpawnCancelled()) {
                mob.finalizeSpawn((ServerLevelAccessor)level, finalizeEvent.getDifficulty(), finalizeEvent.getSpawnType(), finalizeEvent.getSpawnData());
            }
        }
        return level.tryAddFreshEntityWithPassengers((Entity)entity);
    }

    private void resetTimer() {
        this.tile.resetTimer();
        this.broadcastEvent(this.tile.getLevel(), this.tile.getBlockPos(), 1);
    }

    private boolean hasReachedSpawnCap(LivingEntity living) {
        BlockPos pos = this.tile.getBlockPos();
        AABB box = new AABB((double)(pos.getX() - 16), (double)(pos.getY() - 16), (double)(pos.getZ() - 16), (double)(pos.getX() + 16), (double)(pos.getY() + 16), (double)(pos.getZ() + 16));
        int mobCount = this.tile.getLevel().getEntitiesOfClass(living.getClass(), box, e -> e != null && e.getPersistentData().getBoolean("cageBorn")).size();
        return mobCount >= SoulShards.CONFIG.getBalance().getSpawnCap();
    }

    private boolean canSpawnInLight(LivingEntity entityLiving) {
        boolean light = this.tile.getLevel().getLightEngine().getRawBrightness(this.tile.getBlockPos(), 15) <= 8;
        return !(entityLiving instanceof Mob) || light;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level level, BlockPos pos) {
        if (this.tile.getBinding() == null) {
            return null;
        }
        ResourceLocation key = this.tile.getBinding().getBoundEntity();
        if (key == null) {
            return null;
        }
        return RENDER_ENTITY_CACHE.computeIfAbsent(key, name -> {
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(name);
            if (type == null) {
                return EntityType.PIG.create(level);
            }
            Entity entity = type.create(level);
            if (entity == null) {
                return EntityType.PIG.create(level);
            }
            return entity;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getSpin() {
        return this.mobRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getoSpin() {
        return this.prevMobRotation;
    }

    public void broadcastEvent(Level level, BlockPos blockPos, int event) {
        level.blockEvent(blockPos, Blocks.SPAWNER, event, 0);
    }
}

