/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.DataStructures;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TickingBlockEntity;

public record WorldPos(BlockPos pos, ResourceKey<Level> type, UUID id) {
    public static StreamCodec<ByteBuf, WorldPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, WorldPos::pos, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), WorldPos::type, (StreamCodec)UUIDUtil.STREAM_CODEC, WorldPos::id, WorldPos::new);

    public static WorldPos getPosFromEntity(Entity entity) {
        return new WorldPos(entity.getOnPos(), (ResourceKey<Level>)entity.getCommandSenderWorld().dimension(), entity.getUUID());
    }

    public static WorldPos getPosFromTileEntity(TickingBlockEntity entity, Level level) {
        return new WorldPos(entity.getPos(), (ResourceKey<Level>)level.dimension(), UUID.randomUUID());
    }

    public UUID getID() {
        return this.id;
    }
}

