/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.DataStructures.LoadedChunkData;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.server.level.ServerLevel;

public class LoadedChunksCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chunks").then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).executes(x -> LoadedChunksCommand.run((CommandContext<CommandSourceStack>)x, 0, null)))).executes(x -> LoadedChunksCommand.run((CommandContext<CommandSourceStack>)x, 0, null))).then(Commands.literal((String)"byLocation").then(Commands.argument((String)"loc", (ArgumentType)StringArgumentType.word()).executes(x -> LoadedChunksCommand.run((CommandContext<CommandSourceStack>)x, 1, StringArgumentType.getString((CommandContext)x, (String)"loc")))))).then(Commands.literal((String)"byTicket").then(Commands.argument((String)"tic", (ArgumentType)StringArgumentType.word()).executes(x -> LoadedChunksCommand.run((CommandContext<CommandSourceStack>)x, 2, StringArgumentType.getString((CommandContext)x, (String)"tic")))));
    }

    public static int run(CommandContext<CommandSourceStack> context, int type, String word) throws CommandSyntaxException {
        List<ServerLevel> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        LoadedChunkData loadedChunkData = new LoadedChunkData(worlds);
        CrashUtils.runNextTick(world -> LoadedChunksCommand.reply(type, loadedChunkData, context, word));
        return 1;
    }

    public static void reply(int type, LoadedChunkData loadedChunkData, CommandContext<CommandSourceStack> context, String word) {
        try {
            switch (type) {
                case 0: {
                    loadedChunkData.reply((CommandSourceStack)context.getSource());
                    break;
                }
                case 1: {
                    loadedChunkData.replyWithLocation((CommandSourceStack)context.getSource(), word);
                    break;
                }
                case 2: {
                    loadedChunkData.replyWithTicket((CommandSourceStack)context.getSource(), word);
                }
            }
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent("Exception getting player"), true);
        }
    }
}

