/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.buffer;

import codechicken.lib.model.CachedFormat;
import codechicken.lib.model.Quad;
import codechicken.lib.render.buffer.ISpriteAwareVertexConsumer;
import codechicken.lib.util.VectorUtils;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class BakedQuadVertexBuilder
implements VertexConsumer,
ISpriteAwareVertexConsumer {
    private final List<BakedQuad> quadList = new ArrayList<BakedQuad>();
    private final VertexFormat.Mode mode;
    private final Quad current = new Quad();
    private CachedFormat format;
    private int vertex = -1;

    public BakedQuadVertexBuilder() {
        this(VertexFormat.Mode.QUADS);
    }

    public BakedQuadVertexBuilder(VertexFormat format) {
        this(format, VertexFormat.Mode.QUADS);
    }

    public BakedQuadVertexBuilder(CachedFormat format) {
        this(format, VertexFormat.Mode.QUADS);
    }

    public BakedQuadVertexBuilder(VertexFormat.Mode mode) {
        this(CachedFormat.BLOCK, mode);
    }

    public BakedQuadVertexBuilder(VertexFormat format, VertexFormat.Mode mode) {
        this(CachedFormat.lookup(format), mode);
    }

    public BakedQuadVertexBuilder(CachedFormat format, VertexFormat.Mode mode) {
        if (mode != VertexFormat.Mode.QUADS && mode != VertexFormat.Mode.TRIANGLES) {
            throw new IllegalArgumentException("Only QUADS or TRIANGLES supported. Got: " + String.valueOf(mode));
        }
        this.mode = mode;
        this.setFormat(format);
    }

    public void setFormat(VertexFormat format) {
        this.setFormat(CachedFormat.lookup(format));
    }

    public void setFormat(CachedFormat format) {
        this.format = format;
        this.current.reset(format);
    }

    public void reset() {
        this.quadList.clear();
        this.vertex = -1;
    }

    @Override
    public void sprite(TextureAtlasSprite sprite) {
        this.current.setTexture(sprite);
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        if (!this.format.hasPosition) {
            return this;
        }
        this.endPrevVertex();
        this.current.vertices[this.vertex].vec()[0] = x;
        this.current.vertices[this.vertex].vec()[1] = y;
        this.current.vertices[this.vertex].vec()[2] = z;
        return this;
    }

    public VertexConsumer setColor(int red, int green, int blue, int alpha) {
        if (!this.format.hasColor) {
            return this;
        }
        this.current.vertices[this.vertex].color()[0] = (float)red / 255.0f;
        this.current.vertices[this.vertex].color()[1] = (float)green / 255.0f;
        this.current.vertices[this.vertex].color()[2] = (float)blue / 255.0f;
        this.current.vertices[this.vertex].color()[3] = (float)alpha / 255.0f;
        return this;
    }

    public VertexConsumer setUv(float u, float v) {
        if (!this.format.hasUV) {
            return this;
        }
        this.current.vertices[this.vertex].uv()[0] = u;
        this.current.vertices[this.vertex].uv()[1] = v;
        return this;
    }

    public VertexConsumer setUv1(int u, int v) {
        if (!this.format.hasOverlay) {
            return this;
        }
        this.current.vertices[this.vertex].overlay()[0] = (float)u / 240.0f;
        this.current.vertices[this.vertex].overlay()[1] = (float)v / 240.0f;
        return this;
    }

    public VertexConsumer setUv2(int u, int v) {
        if (!this.format.hasLightMap) {
            return this;
        }
        this.current.vertices[this.vertex].lightmap()[0] = (float)u / 240.0f;
        this.current.vertices[this.vertex].lightmap()[1] = (float)v / 240.0f;
        return this;
    }

    public VertexConsumer setNormal(float x, float y, float z) {
        if (!this.format.hasNormal) {
            return this;
        }
        this.current.vertices[this.vertex].normal()[0] = x;
        this.current.vertices[this.vertex].normal()[1] = y;
        this.current.vertices[this.vertex].normal()[2] = z;
        return this;
    }

    private void endPrevVertex() {
        ++this.vertex;
        if (this.vertex == this.mode.primitiveLength) {
            if (this.mode == VertexFormat.Mode.TRIANGLES) {
                for (int e = 0; e < this.current.format().elementCount; ++e) {
                    System.arraycopy(this.current.vertices[2].raw[e], 0, this.current.vertices[3].raw[e], 0, 4);
                }
            }
            if (this.current.sprite == null) {
                throw new IllegalStateException("Sprite not set.");
            }
            this.current.setQuadOrientation(VectorUtils.findSideE(Vector3.fromArray(this.current.vertices[0].normal())));
            this.quadList.add(this.current.bake());
            this.current.reset(this.format);
            this.vertex = 0;
        }
    }

    public List<BakedQuad> bake() {
        this.endPrevVertex();
        this.vertex = -1;
        return new ArrayList<BakedQuad>(this.quadList);
    }
}

