/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.slot;

import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class SlotItemHandlerUnconditioned
extends SlotItemHandler {
    private final ItemStackHandlerAA inv;

    public SlotItemHandlerUnconditioned(ItemStackHandlerAA inv, int index, int xPosition, int yPosition) {
        super((IItemHandler)inv, index, xPosition, yPosition);
        this.inv = inv;
    }

    public boolean mayPlace(ItemStack stack) {
        if (stack.isEmpty() || !this.inv.canAccept(this.getSlotIndex(), stack, false)) {
            return false;
        }
        ItemStack currentStack = this.inv.getStackInSlot(this.getSlotIndex());
        this.inv.setStackInSlot(this.getSlotIndex(), ItemStack.EMPTY);
        ItemStack remainder = this.inv.insertItem(this.getSlotIndex(), stack, true, false);
        this.inv.setStackInSlot(this.getSlotIndex(), currentStack);
        return remainder.isEmpty() || remainder.getCount() < stack.getCount();
    }

    @Nonnull
    public ItemStack getItem() {
        return this.inv.getStackInSlot(this.getSlotIndex());
    }

    public void set(ItemStack stack) {
        this.inv.setStackInSlot(this.getSlotIndex(), stack);
        this.setChanged();
    }

    public int getMaxStackSize(ItemStack stack) {
        ItemStack maxAdd = stack.copy();
        maxAdd.setCount(stack.getMaxStackSize());
        ItemStack currentStack = this.inv.getStackInSlot(this.getSlotIndex());
        this.inv.setStackInSlot(this.getSlotIndex(), ItemStack.EMPTY);
        ItemStack remainder = this.inv.insertItem(this.getSlotIndex(), maxAdd, true, false);
        this.inv.setStackInSlot(this.getSlotIndex(), currentStack);
        return stack.getMaxStackSize() - remainder.getCount();
    }

    public boolean mayPickup(Player playerIn) {
        return !this.inv.extractItem(this.getSlotIndex(), 1, true, false).isEmpty();
    }

    public ItemStack remove(int amount) {
        return this.inv.extractItem(this.getSlotIndex(), amount, false, false);
    }
}

