/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapes {
    static final VoxelShape CANOLA_PRESS_SHAPE = Stream.of(Block.box((double)0.5, (double)8.0, (double)0.5, (double)3.5, (double)10.0, (double)3.5), Block.box((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.box((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), Block.box((double)12.5, (double)14.0, (double)12.5, (double)15.5, (double)16.0, (double)15.5), Block.box((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), Block.box((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0), Block.box((double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0), Block.box((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0), Block.box((double)12.5, (double)14.0, (double)0.5, (double)15.5, (double)16.0, (double)3.5), Block.box((double)0.5, (double)14.0, (double)0.5, (double)3.5, (double)16.0, (double)3.5), Block.box((double)0.5, (double)14.0, (double)12.5, (double)3.5, (double)16.0, (double)15.5), Block.box((double)12.5, (double)8.0, (double)12.5, (double)15.5, (double)10.0, (double)15.5), Block.box((double)12.5, (double)8.0, (double)0.5, (double)15.5, (double)10.0, (double)3.5), Block.box((double)0.5, (double)8.0, (double)12.5, (double)3.5, (double)10.0, (double)15.5), Block.box((double)0.5, (double)5.0, (double)12.5, (double)3.5, (double)7.0, (double)15.5), Block.box((double)0.5, (double)5.0, (double)0.5, (double)3.5, (double)7.0, (double)3.5), Block.box((double)12.5, (double)5.0, (double)0.5, (double)15.5, (double)7.0, (double)3.5), Block.box((double)12.5, (double)5.0, (double)12.5, (double)15.5, (double)7.0, (double)15.5), Block.box((double)12.5, (double)-0.01, (double)0.5, (double)15.5, (double)1.99, (double)3.5), Block.box((double)0.5, (double)-0.01, (double)0.5, (double)3.5, (double)1.99, (double)3.5), Block.box((double)0.5, (double)-0.01, (double)12.5, (double)3.5, (double)1.99, (double)15.5), Block.box((double)12.5, (double)-0.01, (double)12.5, (double)15.5, (double)1.99, (double)15.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    static final VoxelShape BATBOX_SHAPE = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), Block.box((double)1.0, (double)1.0, (double)14.0, (double)2.0, (double)6.0, (double)15.0), Block.box((double)14.0, (double)1.0, (double)14.0, (double)15.0, (double)6.0, (double)15.0), Block.box((double)1.0, (double)1.0, (double)1.0, (double)2.0, (double)6.0, (double)2.0), Block.box((double)14.0, (double)1.0, (double)1.0, (double)15.0, (double)6.0, (double)2.0), Block.box((double)1.0, (double)5.0, (double)2.0, (double)2.0, (double)6.0, (double)14.0), Block.box((double)14.0, (double)1.0, (double)2.0, (double)15.0, (double)2.0, (double)14.0), Block.box((double)14.0, (double)5.0, (double)2.0, (double)15.0, (double)6.0, (double)14.0), Block.box((double)1.0, (double)1.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0), Block.box((double)2.0, (double)5.0, (double)14.0, (double)14.0, (double)6.0, (double)15.0), Block.box((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)2.0, (double)2.0), Block.box((double)2.0, (double)5.0, (double)1.0, (double)14.0, (double)6.0, (double)2.0), Block.box((double)2.0, (double)1.0, (double)14.0, (double)14.0, (double)2.0, (double)15.0), Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    static final VoxelShape SIMPLE_STAND_SHAPE = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    static final VoxelShape BARREL_SHAPE = Stream.of(Block.box((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)2.0), Block.box((double)2.0, (double)1.0, (double)14.0, (double)14.0, (double)15.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.box((double)1.0, (double)1.0, (double)2.0, (double)2.0, (double)15.0, (double)14.0), Block.box((double)14.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    static final VoxelShape FIREWORKS_BOX_SHAPE = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0), Block.box((double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.box((double)4.0, (double)15.0, (double)4.0, (double)6.0, (double)16.0, (double)6.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)7.0, (double)15.0, (double)4.0, (double)9.0, (double)16.0, (double)6.0), Block.box((double)10.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)6.0), Block.box((double)10.0, (double)15.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0), Block.box((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)4.0, (double)15.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), Block.box((double)4.0, (double)15.0, (double)10.0, (double)6.0, (double)16.0, (double)12.0), Block.box((double)7.0, (double)15.0, (double)10.0, (double)9.0, (double)16.0, (double)12.0), Block.box((double)10.0, (double)15.0, (double)10.0, (double)12.0, (double)16.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    static final VoxelShape GLASS_SHAPE = Stream.of(Block.box((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)15.0), Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0), Block.box((double)0.0, (double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0), Block.box((double)15.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    static final VoxelShape HEAT_COLLECTOR_SHAPE = Stream.of(Block.box((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)5.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0), Block.box((double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.box((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), Block.box((double)15.0, (double)10.0, (double)4.0, (double)16.0, (double)11.0, (double)12.0), Block.box((double)15.0, (double)6.0, (double)4.0, (double)16.0, (double)7.0, (double)12.0), Block.box((double)15.0, (double)8.0, (double)4.0, (double)16.0, (double)9.0, (double)12.0), Block.box((double)4.0, (double)10.0, (double)15.0, (double)12.0, (double)11.0, (double)16.0), Block.box((double)4.0, (double)8.0, (double)15.0, (double)12.0, (double)9.0, (double)16.0), Block.box((double)4.0, (double)6.0, (double)15.0, (double)12.0, (double)7.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)5.0, (double)16.0), Block.box((double)0.0, (double)10.0, (double)4.0, (double)1.0, (double)11.0, (double)12.0), Block.box((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)5.0, (double)12.0), Block.box((double)0.0, (double)6.0, (double)4.0, (double)1.0, (double)7.0, (double)12.0), Block.box((double)0.0, (double)8.0, (double)4.0, (double)1.0, (double)9.0, (double)12.0), Block.box((double)4.0, (double)10.0, (double)0.0, (double)12.0, (double)11.0, (double)1.0), Block.box((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)9.0, (double)1.0), Block.box((double)4.0, (double)6.0, (double)0.0, (double)12.0, (double)7.0, (double)1.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)5.0, (double)1.0), Block.box((double)2.0, (double)14.0, (double)2.0, (double)5.0, (double)15.0, (double)14.0), Block.box((double)5.0, (double)14.0, (double)2.0, (double)11.0, (double)15.0, (double)5.0), Block.box((double)5.0, (double)14.0, (double)11.0, (double)11.0, (double)15.0, (double)14.0), Block.box((double)11.0, (double)14.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)2.0, (double)15.0, (double)14.0), Block.box((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)15.0, (double)14.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)14.0, (double)15.0, (double)15.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    static final VoxelShape HOPPING_ITEM_VIEWER_SHAPE = Stream.of(Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.box((double)1.0, (double)11.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0), Block.box((double)14.0, (double)11.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)2.0, (double)11.0, (double)1.0, (double)14.0, (double)15.0, (double)2.0), Block.box((double)2.0, (double)11.0, (double)14.0, (double)14.0, (double)15.0, (double)15.0), Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)0.0, (double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0), Block.box((double)0.0, (double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)11.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)11.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    static final VoxelShape BOOSTER_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    static final VoxelShape SUPPRESSOR_SHAPE = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0), Block.box((double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.box((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0), Block.box((double)9.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)7.0), Block.box((double)9.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)7.0), Block.box((double)3.0, (double)15.0, (double)3.0, (double)7.0, (double)16.0, (double)7.0), Block.box((double)9.0, (double)2.0, (double)9.0, (double)13.0, (double)14.0, (double)13.0), Block.box((double)9.0, (double)15.0, (double)9.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)3.0, (double)2.0, (double)9.0, (double)7.0, (double)14.0, (double)13.0), Block.box((double)3.0, (double)15.0, (double)9.0, (double)7.0, (double)16.0, (double)13.0), Block.box((double)3.0, (double)2.0, (double)3.0, (double)7.0, (double)14.0, (double)7.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    static final VoxelShape SIMPLE_GENERATOR_SHAPE = Stream.of(Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    static final class VoxelShapeUtils {
        private static final Vec3 fromOrigin = new Vec3(-0.5, -0.5, -0.5);

        VoxelShapeUtils() {
        }

        static AABB rotate(AABB box, Direction side) {
            return switch (side) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> box;
                case Direction.UP -> new AABB(box.minX, -box.minY, -box.minZ, box.maxX, -box.maxY, -box.maxZ);
                case Direction.NORTH -> new AABB(box.minX, -box.minZ, box.minY, box.maxX, -box.maxZ, box.maxY);
                case Direction.SOUTH -> new AABB(-box.minX, -box.minZ, -box.minY, -box.maxX, -box.maxZ, -box.maxY);
                case Direction.WEST -> new AABB(box.minY, -box.minZ, -box.minX, box.maxY, -box.maxZ, -box.maxX);
                case Direction.EAST -> new AABB(-box.minY, -box.minZ, box.minX, -box.maxY, -box.maxZ, box.maxX);
            };
        }

        public static AABB rotate(AABB box, Rotation rotation) {
            return switch (rotation) {
                default -> throw new MatchException(null, null);
                case Rotation.NONE -> box;
                case Rotation.CLOCKWISE_90 -> new AABB(-box.minZ, box.minY, box.minX, -box.maxZ, box.maxY, box.maxX);
                case Rotation.CLOCKWISE_180 -> new AABB(-box.minX, box.minY, -box.minZ, -box.maxX, box.maxY, -box.maxZ);
                case Rotation.COUNTERCLOCKWISE_90 -> new AABB(box.minZ, box.minY, -box.minX, box.maxZ, box.maxY, -box.maxX);
            };
        }

        public static VoxelShape rotate(VoxelShape shape, Direction side) {
            return VoxelShapeUtils.rotate(shape, side, VoxelShapeUtils::rotate);
        }

        public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
            return VoxelShapeUtils.rotate(shape, rotation, VoxelShapeUtils::rotate);
        }

        public static <D> VoxelShape rotate(VoxelShape shape, D data, BiFunction<AABB, D, AABB> rotateFunction) {
            ArrayList<VoxelShape> rotatedPieces = new ArrayList<VoxelShape>();
            List sourceBoundingBoxes = shape.toAabbs();
            for (AABB sourceBoundingBox : sourceBoundingBoxes) {
                rotatedPieces.add(Shapes.create((AABB)rotateFunction.apply(sourceBoundingBox.move(VoxelShapeUtils.fromOrigin.x, VoxelShapeUtils.fromOrigin.y, VoxelShapeUtils.fromOrigin.z), data).move(-VoxelShapeUtils.fromOrigin.x, -VoxelShapeUtils.fromOrigin.z, -VoxelShapeUtils.fromOrigin.z)));
            }
            return (VoxelShape)rotatedPieces.stream().reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        }
    }

    static final class CrystalClusterShapes {
        static final VoxelShape SHAPE_U = Stream.of(Block.box((double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0, (double)8.0), Block.box((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)14.0, (double)2.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)8.0, (double)6.0, (double)8.0), Block.box((double)8.0, (double)2.0, (double)8.0, (double)12.0, (double)8.0, (double)12.0), Block.box((double)8.0, (double)0.0, (double)2.0, (double)12.0, (double)4.0, (double)6.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        static final VoxelShape SHAPE_D = VoxelShapeUtils.rotate(SHAPE_U, Direction.UP);
        static final VoxelShape SHAPE_N = VoxelShapeUtils.rotate(SHAPE_D, Direction.NORTH);
        static final VoxelShape SHAPE_E = VoxelShapeUtils.rotate(SHAPE_D, Direction.EAST);
        static final VoxelShape SHAPE_S = VoxelShapeUtils.rotate(SHAPE_D, Direction.SOUTH);
        static final VoxelShape SHAPE_W = VoxelShapeUtils.rotate(SHAPE_D, Direction.WEST);

        CrystalClusterShapes() {
        }
    }

    static final class TinyTorchShapes {
        static final VoxelShape STANDING_AABB = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0);
        static final VoxelShape TORCH_NORTH_AABB = Block.box((double)7.0, (double)4.0, (double)13.0, (double)9.0, (double)9.0, (double)16.0);
        static final VoxelShape TORCH_SOUTH_AABB = Block.box((double)7.0, (double)4.0, (double)0.0, (double)9.0, (double)9.0, (double)3.0);
        static final VoxelShape TORCH_WEST_AABB = Block.box((double)13.0, (double)4.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
        static final VoxelShape TORCH_EAST_AABB = Block.box((double)0.0, (double)4.0, (double)7.0, (double)3.0, (double)9.0, (double)9.0);

        TinyTorchShapes() {
        }
    }

    static final class LaserRelayShapes {
        static final VoxelShape SHAPE_U = Stream.of(Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.box((double)6.0, (double)4.0, (double)6.0, (double)7.0, (double)5.0, (double)7.0), Block.box((double)9.0, (double)4.0, (double)9.0, (double)10.0, (double)5.0, (double)10.0), Block.box((double)6.0, (double)4.0, (double)9.0, (double)7.0, (double)5.0, (double)10.0), Block.box((double)3.0, (double)1.0, (double)12.0, (double)4.0, (double)5.0, (double)13.0), Block.box((double)12.0, (double)1.0, (double)12.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)3.0, (double)1.0, (double)3.0, (double)4.0, (double)5.0, (double)4.0), Block.box((double)12.0, (double)1.0, (double)3.0, (double)13.0, (double)5.0, (double)4.0), Block.box((double)3.0, (double)4.0, (double)4.0, (double)4.0, (double)5.0, (double)12.0), Block.box((double)3.0, (double)1.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0), Block.box((double)12.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0), Block.box((double)12.0, (double)1.0, (double)4.0, (double)13.0, (double)2.0, (double)12.0), Block.box((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)5.0, (double)13.0), Block.box((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)4.0), Block.box((double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)2.0, (double)13.0), Block.box((double)4.0, (double)1.0, (double)3.0, (double)12.0, (double)2.0, (double)4.0), Block.box((double)9.0, (double)4.0, (double)6.0, (double)10.0, (double)5.0, (double)7.0), Block.box((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0), Block.box((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        static final VoxelShape SHAPE_D = VoxelShapeUtils.rotate(SHAPE_U, Direction.UP);
        static final VoxelShape SHAPE_N = VoxelShapeUtils.rotate(SHAPE_D, Direction.NORTH);
        static final VoxelShape SHAPE_E = VoxelShapeUtils.rotate(SHAPE_D, Direction.EAST);
        static final VoxelShape SHAPE_S = VoxelShapeUtils.rotate(SHAPE_D, Direction.SOUTH);
        static final VoxelShape SHAPE_W = VoxelShapeUtils.rotate(SHAPE_D, Direction.WEST);

        LaserRelayShapes() {
        }
    }

    static class CoffeeMachineShapes {
        static final VoxelShape NORTH = Stream.of(Block.box((double)13.0, (double)2.0, (double)4.0, (double)14.0, (double)3.0, (double)5.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.box((double)7.0, (double)1.0, (double)8.0, (double)14.0, (double)9.0, (double)14.0), Block.box((double)6.0, (double)9.0, (double)3.0, (double)15.0, (double)11.0, (double)15.0), Block.box((double)8.0, (double)11.0, (double)8.0, (double)13.0, (double)13.0, (double)13.0), Block.box((double)10.0, (double)8.0, (double)4.0, (double)11.0, (double)9.0, (double)5.0), Block.box((double)12.0, (double)2.0, (double)2.0, (double)13.0, (double)7.0, (double)7.0), Block.box((double)13.0, (double)11.0, (double)7.0, (double)14.0, (double)14.0, (double)14.0), Block.box((double)8.0, (double)11.0, (double)7.0, (double)13.0, (double)14.0, (double)8.0), Block.box((double)14.0, (double)1.0, (double)7.0, (double)15.0, (double)9.0, (double)8.0), Block.box((double)3.0, (double)3.0, (double)10.0, (double)4.0, (double)5.0, (double)11.0), Block.box((double)3.0, (double)2.0, (double)10.0, (double)7.0, (double)3.0, (double)11.0), Block.box((double)3.0, (double)3.0, (double)12.0, (double)4.0, (double)5.0, (double)13.0), Block.box((double)2.0, (double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)14.0), Block.box((double)2.0, (double)11.0, (double)11.0, (double)4.0, (double)12.0, (double)13.0), Block.box((double)1.0, (double)1.0, (double)11.0, (double)2.0, (double)12.0, (double)13.0), Block.box((double)9.0, (double)2.0, (double)6.0, (double)12.0, (double)7.0, (double)7.0), Block.box((double)8.0, (double)1.0, (double)2.0, (double)13.0, (double)2.0, (double)7.0), Block.box((double)13.0, (double)5.0, (double)4.0, (double)14.0, (double)6.0, (double)5.0), Block.box((double)14.0, (double)2.0, (double)4.0, (double)15.0, (double)6.0, (double)5.0), Block.box((double)7.0, (double)11.0, (double)7.0, (double)8.0, (double)14.0, (double)14.0), Block.box((double)8.0, (double)11.0, (double)13.0, (double)13.0, (double)14.0, (double)14.0), Block.box((double)14.0, (double)1.0, (double)14.0, (double)15.0, (double)9.0, (double)15.0), Block.box((double)6.0, (double)1.0, (double)14.0, (double)7.0, (double)9.0, (double)15.0), Block.box((double)6.0, (double)1.0, (double)7.0, (double)7.0, (double)9.0, (double)8.0), Block.box((double)3.0, (double)2.0, (double)12.0, (double)7.0, (double)3.0, (double)13.0), Block.box((double)8.0, (double)2.0, (double)2.0, (double)9.0, (double)7.0, (double)7.0), Block.box((double)9.0, (double)2.0, (double)2.0, (double)12.0, (double)7.0, (double)3.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        static final VoxelShape EAST = VoxelShapeUtils.rotate(NORTH, Rotation.CLOCKWISE_90);
        static final VoxelShape SOUTH = VoxelShapeUtils.rotate(NORTH, Rotation.CLOCKWISE_180);
        static final VoxelShape WEST = VoxelShapeUtils.rotate(NORTH, Rotation.COUNTERCLOCKWISE_90);

        CoffeeMachineShapes() {
        }
    }
}

