/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.VoxelShapes;
import de.ellpeck.actuallyadditions.mod.blocks.base.FullyDirectionalBlock;
import de.ellpeck.actuallyadditions.mod.items.metalists.Crystals;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrystalClusterBlock
extends FullyDirectionalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public CrystalClusterBlock(Crystals crystal) {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).lightLevel(e -> 7).sound(SoundType.AMETHYST_CLUSTER).noOcclusion().strength(0.25f, 1.0f));
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return CrystalClusterBlock.canAttach(level, pos, ((Direction)state.getValue((Property)FACING)).getOpposite());
    }

    private static boolean canAttach(LevelReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.relative(direction);
        return reader.getBlockState(blockpos).isFaceSturdy((BlockGetter)reader, blockpos, direction.getOpposite());
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    @Override
    public BlockState getBaseConstructorState() {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case UP: {
                return VoxelShapes.CrystalClusterShapes.SHAPE_U;
            }
            case DOWN: {
                return VoxelShapes.CrystalClusterShapes.SHAPE_D;
            }
            case EAST: {
                return VoxelShapes.CrystalClusterShapes.SHAPE_E;
            }
            case SOUTH: {
                return VoxelShapes.CrystalClusterShapes.SHAPE_S;
            }
            case WEST: {
                return VoxelShapes.CrystalClusterShapes.SHAPE_W;
            }
        }
        return VoxelShapes.CrystalClusterShapes.SHAPE_N;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return ((Direction)state.getValue((Property)FACING)).getOpposite() == facing && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }
}

