/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.datagen;

import com.github.bigenergy.glassential.datagen.GlassentialTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class GlassentialItemTag
extends ItemTagsProvider {
    public GlassentialItemTag(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, ExistingFileHelper helper) {
        super(output, lookup, blockTags, "glassential", helper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.copy(GlassentialTags.Blocks.DOORS_DYED, GlassentialTags.Items.DOORS_DYED);
        this.copy(GlassentialTags.Blocks.TRAPDOORS_DYED, GlassentialTags.Items.TRAPDOORS_DYED);
        GlassentialTags.Blocks.DOORS_DYED_BY_COLOR.forEach((color, bTag) -> this.copy((TagKey)bTag, (TagKey)GlassentialTags.Items.DOORS_DYED_BY_COLOR.get(color)));
        GlassentialTags.Blocks.TRAPDOORS_DYED_BY_COLOR.forEach((color, bTag) -> this.copy((TagKey)bTag, (TagKey)GlassentialTags.Items.TRAPDOORS_DYED_BY_COLOR.get(color)));
        for (DyeColor color2 : DyeColor.values()) {
            this.copy(GlassentialItemTag.cDyedBlock(color2), GlassentialItemTag.cDyedItem(color2));
        }
    }

    private static TagKey<Block> cDyedBlock(DyeColor color) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyed/" + color.getName())));
    }

    private static TagKey<Item> cDyedItem(DyeColor color) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyed/" + color.getName())));
    }
}

