/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.datagen;

import com.github.bigenergy.glassential.datagen.GlassentialTags;
import com.github.bigenergy.glassential.init.GlassentialBlocks;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlassentialBlockTag
extends BlockTagsProvider {
    public GlassentialBlockTag(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "glassential", existingFileHelper);
    }

    protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.tag(BlockTags.IMPERMEABLE).add((Object[])((Block[])Stream.of(GlassentialBlocks.GLASSES.stream(), GlassentialBlocks.GLASSES_TINTED.stream(), GlassentialBlocks.PANES.stream(), GlassentialBlocks.SLABS.stream()).flatMap(s -> s.map(DeferredHolder::get)).toArray(Block[]::new)));
        this.tag(Tags.Blocks.GLASS_BLOCKS).add((Object[])((Block[])Stream.concat(GlassentialBlocks.GLASSES.stream(), GlassentialBlocks.GLASSES_TINTED.stream()).map(DeferredHolder::get).toArray(Block[]::new)));
        this.tag(Tags.Blocks.GLASS_BLOCKS_TINTED).add((Object[])((Block[])GlassentialBlocks.GLASSES_TINTED.stream().map(DeferredHolder::get).toArray(Block[]::new)));
        this.tag(Tags.Blocks.GLASS_PANES).add((Object[])((Block[])GlassentialBlocks.PANES.stream().map(DeferredHolder::get).toArray(Block[]::new)));
        this.tag(BlockTags.DOORS).add((Object[])((Block[])GlassentialBlocks.DOORS.stream().map(DeferredHolder::get).toArray(Block[]::new)));
        this.tag(GlassentialTags.Blocks.DOORS_DYED).add((Object[])((Block[])GlassentialBlocks.DOORS_DYED.stream().map(DeferredHolder::get).toArray(Block[]::new)));
        this.tag(BlockTags.DOORS).add((Object[])((Block[])GlassentialBlocks.DOORS_DYED.stream().map(DeferredHolder::get).toArray(Block[]::new)));
        this.tag(Tags.Blocks.DYED).add((Object[])((Block[])GlassentialBlocks.DOORS_DYED.stream().map(DeferredHolder::get).toArray(Block[]::new)));
        GlassentialBlocks.DOOR_COLOR.forEach((def, color) -> {
            this.tag(GlassentialTags.Blocks.DOORS_DYED_BY_COLOR.get(color)).add((Object)((Block)def.get()));
            this.tag(GlassentialBlockTag.cDyedBlock(color)).add((Object)((Block)def.get()));
        });
        this.tag(BlockTags.TRAPDOORS).add((Object[])((Block[])Stream.concat(GlassentialBlocks.TRAPDOORS.stream(), GlassentialBlocks.TRAPDOORS_DYED.stream()).map(DeferredHolder::get).toArray(Block[]::new)));
        this.tag(GlassentialTags.Blocks.TRAPDOORS_DYED).add((Object[])((Block[])GlassentialBlocks.TRAPDOORS_DYED.stream().map(DeferredHolder::get).toArray(Block[]::new)));
        this.tag(Tags.Blocks.DYED).add((Object[])((Block[])GlassentialBlocks.TRAPDOORS_DYED.stream().map(DeferredHolder::get).toArray(Block[]::new)));
        GlassentialBlocks.TRAPDOOR_COLOR.forEach((def, color) -> {
            this.tag(GlassentialTags.Blocks.TRAPDOORS_DYED_BY_COLOR.get(color)).add((Object)((Block)def.get()));
            this.tag(GlassentialBlockTag.cDyedBlock(color)).add((Object)((Block)def.get()));
        });
    }

    @Nullable
    private static DyeColor parseColorFromPath(String path) {
        for (DyeColor c : DyeColor.values()) {
            if (!path.startsWith(c.getName() + "_")) continue;
            return c;
        }
        return null;
    }

    private static TagKey<Block> cDyedBlock(DyeColor color) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyed/" + color.getName())));
    }
}

