/*
 * Decompiled with CFR 0.152.
 */
package com.github.bigenergy.glassential.blocks;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GravityGlassBlock
extends TransparentBlock {
    private static final double MAX_DOWNWARD_SPEED = -0.1;
    private static final float FALL_DISTANCE_FACTOR = 0.2f;
    private static final boolean GIVE_SLOW_FALLING = true;
    private static final int SLOW_FALLING_TICKS = 6;
    private static final VoxelShape OUTLINE = GravityGlassBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public GravityGlassBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return !(context instanceof EntityCollisionContext) || !(((EntityCollisionContext)context).getEntity() instanceof Player) ? state.getShape(world, pos) : Shapes.empty();
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return OUTLINE;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.isClientSide) {
            return;
        }
        Vec3 motion = entity.getDeltaMovement();
        if (motion.y < -0.1) {
            entity.setDeltaMovement(motion.x, -0.1, motion.z);
            entity.hurtMarked = true;
        }
        if (entity.fallDistance > 0.0f) {
            entity.fallDistance *= 0.2f;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 6, 0, true, false, false));
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return super.getStateForPlacement(ctx);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.glassential.gravity").withStyle(ChatFormatting.GRAY));
    }
}

