/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.world.raycast;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.caffeinemc.mods.lithium.mixin.world.raycast.ClipContextAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockGetter.class})
public interface BlockGetterMixin {
    @Shadow
    public BlockState getBlockState(BlockPos var1);

    @Shadow
    @Nullable
    public BlockHitResult clipWithInteractionOverride(Vec3 var1, Vec3 var2, BlockPos var3, VoxelShape var4, BlockState var5);

    @Shadow
    public static <T, C> T traverseBlocks(Vec3 start, Vec3 end, C context, BiFunction<C, BlockPos, T> blockHitFactory, Function<C, T> missFactory) {
        throw new AssertionError();
    }

    @Shadow(aliases={"lambda$clip$2"})
    public BlockHitResult method_17743(ClipContext var1, BlockPos var2);

    @Shadow(aliases={"lambda$clip$3"})
    public static BlockHitResult method_17746(ClipContext par1) {
        throw new AssertionError();
    }

    @Overwrite
    default public BlockHitResult clip(ClipContext context) {
        Level l;
        BlockGetterMixin blockGetterMixin;
        return BlockGetterMixin.traverseBlocks(context.getFrom(), context.getTo(), context, this instanceof ServerLevel || (blockGetterMixin = this) instanceof Level && (l = (Level)blockGetterMixin).isClientSide() ? this.lithium$blockHitFactory(context) : this::method_17743, BlockGetterMixin::method_17746);
    }

    @Unique
    private BiFunction<ClipContext, BlockPos, BlockHitResult> lithium$blockHitFactory(final ClipContext context) {
        return new BiFunction<ClipContext, BlockPos, BlockHitResult>(){
            int chunkX = Integer.MIN_VALUE;
            int chunkZ = Integer.MIN_VALUE;
            ChunkAccess chunk = null;
            final boolean handleFluids = ((ClipContextAccessor)context).getFluidHandling() != ClipContext.Fluid.NONE;

            @Override
            public BlockHitResult apply(ClipContext innerContext, BlockPos pos) {
                VoxelShape blockShape;
                Vec3 end;
                BlockState blockState = this.getBlock((LevelReader)BlockGetterMixin.this, pos);
                Vec3 start = innerContext.getFrom();
                BlockHitResult blockHitResult = BlockGetterMixin.this.clipWithInteractionOverride(start, end = innerContext.getTo(), pos, blockShape = innerContext.getBlockShape(blockState, (BlockGetter)BlockGetterMixin.this, pos), blockState);
                double d = blockHitResult == null ? Double.MAX_VALUE : innerContext.getFrom().distanceToSqr(blockHitResult.getLocation());
                double e = Double.MAX_VALUE;
                BlockHitResult fluidHitResult = null;
                if (this.handleFluids) {
                    FluidState fluidState = blockState.getFluidState();
                    VoxelShape fluidShape = innerContext.getFluidShape(fluidState, (BlockGetter)BlockGetterMixin.this, pos);
                    fluidHitResult = fluidShape.clip(start, end, pos);
                    e = fluidHitResult == null ? Double.MAX_VALUE : innerContext.getFrom().distanceToSqr(fluidHitResult.getLocation());
                }
                return d <= e ? blockHitResult : fluidHitResult;
            }

            private BlockState getBlock(LevelReader world, BlockPos blockPos) {
                LevelChunkSection section;
                ChunkAccess chunk;
                if (world.isOutsideBuildHeight(blockPos.getY())) {
                    return Blocks.VOID_AIR.defaultBlockState();
                }
                int chunkX = Pos.ChunkCoord.fromBlockCoord(blockPos.getX());
                int chunkZ = Pos.ChunkCoord.fromBlockCoord(blockPos.getZ());
                if (this.chunkX != chunkX || this.chunkZ != chunkZ) {
                    this.chunk = world.getChunk(chunkX, chunkZ);
                    this.chunkX = chunkX;
                    this.chunkZ = chunkZ;
                }
                if ((chunk = this.chunk) != null && (section = chunk.getSections()[Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)chunk, blockPos.getY())]) != null && !section.hasOnlyAir()) {
                    return section.getBlockState(blockPos.getX() & 0xF, blockPos.getY() & 0xF, blockPos.getZ() & 0xF);
                }
                return Blocks.AIR.defaultBlockState();
            }
        };
    }
}

