/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.almanac.util;

import com.frikinjay.almanac.platform.ConfigHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class ItemNBTUtil {
    private static List<Pattern> blacklistPattern = new ArrayList<Pattern>();
    private static Set<Item> blacklistCache = new HashSet<Item>();
    private static Set<Item> checkedItemsCache = new HashSet<Item>();

    private static boolean isItemOnBlacklist(ItemStack stack) {
        if (stack == null || stack.isEmpty() || blacklistPattern.isEmpty()) {
            return true;
        }
        Item item = stack.getItem();
        if (blacklistCache.contains(item)) {
            return true;
        }
        if (checkedItemsCache.contains(item)) {
            return false;
        }
        ResourceLocation RLItemId = BuiltInRegistries.ITEM.getKey((Object)item);
        if (RLItemId == null) {
            return true;
        }
        String id = RLItemId.toString();
        ItemNBTUtil.prepareBlacklist();
        for (Pattern p : blacklistPattern) {
            if (!p.matcher(id).matches()) continue;
            blacklistCache.add(item);
            return true;
        }
        checkedItemsCache.add(item);
        return false;
    }

    public static boolean isSplitItemStack(ItemStack stack) {
        ItemNBTUtil.prepareBlacklist();
        if (ItemNBTUtil.isItemOnBlacklist(stack)) {
            return false;
        }
        CustomData component = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        return component != null && component.copyTag().isEmpty();
    }

    public static void prepareBlacklist() {
        if (!blacklistPattern.isEmpty()) {
            return;
        }
        List<? extends String> list = ConfigHelper.blacklistItems();
        if (list != null) {
            for (String string : list) {
                String regex = string.replace("*", ".*");
                blacklistPattern.add(Pattern.compile(regex));
            }
            blacklistCache.clear();
            checkedItemsCache.clear();
        }
    }

    public static void fixBug(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        if (ItemNBTUtil.isItemOnBlacklist(stack)) {
            return;
        }
        if (ItemNBTUtil.isSplitItemStack(stack)) {
            stack.remove(DataComponents.CUSTOM_DATA);
        }
    }
}

