/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util.registrypredicate;

import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.registry.RegistryType;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.registrypredicate.EntireRegistryPredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryHolderPredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryIDPredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryNamespacePredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryRegExpPredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryTagIDPredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryTagKeyPredicate;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface RegistryPredicate<T>
extends Predicate<Holder<T>> {
    public static RegistryPredicate<?> of(Context cx, Object from, TypeInfo target) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegistryPredicate.class, Pattern.class, NativeRegExp.class, CharSequence.class, JsonPrimitive.class, BaseFunction.class}, (Object)object, n)) {
            case -1 -> EntireRegistryPredicate.FALSE;
            case 0 -> {
                RegistryPredicate p = (RegistryPredicate)object;
                yield p;
            }
            case 1 -> {
                Pattern pattern = (Pattern)object;
                yield new RegistryRegExpPredicate(pattern);
            }
            case 2 -> {
                NativeRegExp pattern = (NativeRegExp)object;
                yield new RegistryRegExpPredicate(RegExpKJS.wrap(pattern));
            }
            case 3 -> {
                CharSequence cs = (CharSequence)object;
                yield RegistryPredicate.ofString(target, cs.toString());
            }
            case 4 -> {
                JsonPrimitive p = (JsonPrimitive)object;
                yield RegistryPredicate.ofString(target, p.getAsString());
            }
            case 5 -> {
                BaseFunction fn = (BaseFunction)object;
                TypeInfo t = target.param(0);
                Predicate predicate = (Predicate)cx.jsToJava((Object)fn, t.shouldConvert() ? TypeInfo.RAW_PREDICATE.withParams(new TypeInfo[]{t}) : TypeInfo.RAW_PREDICATE);
                yield predicate::test;
            }
            default -> new RegistryHolderPredicate(new Holder.Direct(from));
        };
    }

    @NotNull
    private static RegistryPredicate<?> ofString(TypeInfo target, String s) {
        Record record;
        String string = s;
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"*", "-", String.class, String.class}, (Object)string2, n)) {
                case 0: {
                    record = EntireRegistryPredicate.TRUE;
                    break block6;
                }
                case 1: {
                    record = EntireRegistryPredicate.FALSE;
                    break block6;
                }
                case 2: {
                    String tag = string2;
                    if (tag.charAt(0) != '#') {
                        n = 3;
                        continue block6;
                    }
                    RegistryType<?> reg = RegistryType.ofType(target.param(0));
                    ResourceLocation registryTag = ID.mc(tag.substring(1));
                    if (reg != null) {
                        record = new RegistryTagKeyPredicate(TagKey.create(reg.key(), (ResourceLocation)registryTag));
                        break block6;
                    }
                    record = new RegistryTagIDPredicate(registryTag);
                    break block6;
                }
                case 3: {
                    String namespace = string2;
                    if (namespace.charAt(0) != '@') {
                        n = 4;
                        continue block6;
                    }
                    record = new RegistryNamespacePredicate(namespace.substring(1));
                    break block6;
                }
                default: {
                    Optional opt;
                    Registry registry;
                    Pattern pattern = RegExpKJS.wrap(s);
                    if (pattern != null) {
                        record = new RegistryRegExpPredicate(pattern);
                        break block6;
                    }
                    RegistryType<?> reg = RegistryType.ofType(target.param(0));
                    ResourceLocation id = ID.mc(s);
                    if (reg != null && (registry = (Registry)BuiltInRegistries.REGISTRY.get(reg.key())) != null && (opt = registry.getHolder(id)).isPresent()) {
                        record = new RegistryHolderPredicate((Holder)opt.get());
                        break block6;
                    }
                    record = new RegistryIDPredicate(id);
                    break block6;
                }
            }
            break;
        }
        return record;
    }

    default public List<Holder.Reference<T>> getHolders(Registry<T> registry) {
        return registry.holders().filter(this).toList();
    }

    default public List<T> getValues(Registry<T> registry) {
        return registry.holders().filter(this).map(Holder::value).toList();
    }
}

