/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.block.BlockModificationKubeEvent;
import dev.latvian.mods.kubejs.item.ItemModificationKubeEvent;
import dev.latvian.mods.kubejs.plugin.builtin.event.BlockEvents;
import dev.latvian.mods.kubejs.plugin.builtin.event.ItemEvents;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.type.TypeUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import org.jetbrains.annotations.Nullable;

public class UtilsJS {
    public static final RandomSource RANDOM = RandomSource.create();
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Predicate<Object> ALWAYS_TRUE = o -> true;

    @Nullable
    public static Object wrap(@Nullable Object o, JSObjectType type) {
        if (o == null || o instanceof WrappedJS || o instanceof Number || o instanceof Character || o instanceof String || o instanceof Enum || o.getClass().isPrimitive() && !o.getClass().isArray()) {
            return o;
        }
        if (o instanceof CharSequence || o instanceof ResourceLocation) {
            return o.toString();
        }
        if (o instanceof EndTag || o instanceof JsonNull) {
            return null;
        }
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            return UtilsJS.wrap(w.unwrap(), type);
        }
        if (o instanceof NumericTag) {
            NumericTag tag = (NumericTag)o;
            return tag.getAsNumber();
        }
        if (o instanceof StringTag) {
            StringTag tag = (StringTag)o;
            return tag.getAsString();
        }
        if (o instanceof Tag) {
            return o;
        }
        if (o instanceof Map) {
            return o;
        }
        if (o instanceof Iterable) {
            Iterable itr = (Iterable)o;
            if (!type.checkList()) {
                return null;
            }
            ArrayList list = new ArrayList();
            for (Object o1 : itr) {
                list.add(o1);
            }
            return list;
        }
        if (o.getClass().isArray()) {
            if (type.checkList()) {
                return ListJS.ofArray(o);
            }
            return null;
        }
        if (o instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)o;
            return JsonIO.toPrimitive((JsonElement)json);
        }
        if (o instanceof JsonObject) {
            JsonObject json = (JsonObject)o;
            if (!type.checkMap()) {
                return null;
            }
            HashMap map = new HashMap(json.size());
            for (Map.Entry entry : json.entrySet()) {
                map.put((String)entry.getKey(), entry.getValue());
            }
            return map;
        }
        return o;
    }

    public static <T> Predicate<T> onMatchDo(Predicate<T> predicate, Consumer<T> onMatch) {
        return t -> {
            boolean match = predicate.test(t);
            if (match) {
                onMatch.accept(t);
            }
            return match;
        };
    }

    public static void postModificationEvents() {
        BlockEvents.MODIFICATION.post(ScriptType.STARTUP, new BlockModificationKubeEvent());
        ItemEvents.MODIFICATION.post(ScriptType.STARTUP, new ItemModificationKubeEvent());
    }

    public static String toMappedTypeString(Type type) {
        if (type instanceof Class) {
            Class clz = (Class)type;
            String mapped = clz.getName();
            int ld = mapped.lastIndexOf(46);
            return ld == -1 ? mapped : mapped.substring(ld + 1);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            StringBuilder sb = new StringBuilder();
            Type owner = paramType.getOwnerType();
            if (owner != null) {
                sb.append(UtilsJS.toMappedTypeString(owner));
                sb.append('.');
            }
            sb.append(UtilsJS.toMappedTypeString(TypeUtils.getRawType((Type)paramType)));
            Type[] args = paramType.getActualTypeArguments();
            if (args.length > 0) {
                sb.append('<');
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(args[i]));
                }
                sb.append('>');
            }
            return sb.toString();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrType = (GenericArrayType)type;
            return UtilsJS.toMappedTypeString(arrType.getGenericComponentType()) + "[]";
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            StringBuilder sb = new StringBuilder(typeVar.getName());
            Type[] bounds = typeVar.getBounds();
            if (!(bounds.length <= 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]))) {
                sb.append(" extends ");
                for (int i = 0; i < bounds.length; ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(bounds[i]));
                }
            }
            return sb.toString();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            StringBuilder sb = new StringBuilder().append("?");
            Type[] lowerBounds = wildcard.getLowerBounds();
            Type[] upperBounds = wildcard.getUpperBounds();
            if (lowerBounds.length > 1 || lowerBounds.length == 1 && lowerBounds[0] != null) {
                sb.append(" super ");
                for (int i = 0; i < lowerBounds.length; ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(lowerBounds[i]));
                }
            } else if (upperBounds.length > 1 || upperBounds.length == 1 && !Object.class.equals((Object)upperBounds[0])) {
                sb.append(" extends ");
                for (int i = 0; i < upperBounds.length; ++i) {
                    if (i > 0) {
                        sb.append(" & ");
                    }
                    sb.append(UtilsJS.toMappedTypeString(upperBounds[i]));
                }
            }
            return sb.toString();
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, GenericArrayType, TypeVariable or WildcardType, but <" + String.valueOf(type) + "> is of type " + className);
    }

    @Nullable
    public static CreativeModeTab findCreativeTab(ResourceLocation id) {
        return (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(id);
    }
}

