/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeTypeRegistryContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeOptional;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaData;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaRegistry;
import dev.latvian.mods.kubejs.recipe.schema.function.RecipeFunctionInstance;
import dev.latvian.mods.kubejs.recipe.schema.function.RecipeSchemaFunction;
import dev.latvian.mods.kubejs.recipe.schema.function.ResolvedRecipeSchemaFunction;
import dev.latvian.mods.kubejs.recipe.schema.postprocessing.RecipePostProcessor;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.JsonUtils;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class JsonRecipeSchemaLoader {
    public static void load(RecipeTypeRegistryContext ctx, DynamicOps<JsonElement> jsonOps, RecipeSchemaRegistry event, ResourceManager resourceManager) {
        RecipeSchema schema;
        HashMap<ResourceLocation, RecipeSchemaBuilder> map = new HashMap<ResourceLocation, RecipeSchemaBuilder>();
        Codec<RecipeSchemaData> recipeSchemaDataCodec = RecipeSchemaData.CODEC.apply(ctx);
        for (Map.Entry entry : resourceManager.listResources("kubejs/recipe_schema", path -> path.getPath().endsWith(".json")).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonObject json = (JsonObject)JsonUtils.GSON.fromJson((Reader)reader, JsonObject.class);
                    ResourceLocation id = ((ResourceLocation)entry.getKey()).withPath(((ResourceLocation)entry.getKey()).getPath().substring("kubejs/recipe_schema/".length(), ((ResourceLocation)entry.getKey()).getPath().length() - ".json".length()));
                    DataResult data = recipeSchemaDataCodec.parse(jsonOps, (Object)json);
                    if (data.isSuccess()) {
                        map.put(id, new RecipeSchemaBuilder(id, (RecipeSchemaData)data.getOrThrow()));
                        continue;
                    }
                    ConsoleJS.SERVER.error("Error parsing recipe schema json " + String.valueOf(entry.getKey()) + ": " + data.error().map(DataResult.Error::message).orElse("Unknown Error"));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception ex) {
                ConsoleJS.SERVER.error("Error reading recipe schema json " + String.valueOf(entry.getKey()), ex);
            }
        }
        for (RecipeSchemaBuilder builder : map.values()) {
            for (String m : builder.data.mappings()) {
                ctx.storage().mappings.put(m, builder.id);
            }
        }
        for (RecipeSchemaBuilder builder : map.values()) {
            builder.hidden = builder.data.hidden().orElse(null);
            builder.parent = builder.data.parent().map(map::get).orElse(null);
            builder.overrideType = builder.data.overrideType().orElse(null);
            if (builder.data.recipeFactory().isPresent()) {
                ResourceLocation fname = builder.data.recipeFactory().get();
                builder.recipeFactory = ctx.storage().recipeTypes.get(fname);
                if (builder.recipeFactory == null) {
                    throw new NullPointerException("Recipe factory '" + String.valueOf(fname) + "' not found for recipe schema '" + String.valueOf(builder.id) + "'");
                }
            }
            if (builder.data.keys().isPresent()) {
                builder.keys = new ArrayList();
                for (RecipeSchemaData.RecipeKeyData keyData : builder.data.keys().get()) {
                    try {
                        RecipeComponent<?> type = keyData.type();
                        RecipeKey<?> key = type.key(keyData.name(), keyData.role());
                        if (keyData.defaultOptional()) {
                            key.defaultOptional();
                        } else if (keyData.optional().isPresent()) {
                            JsonElement optionalJson = keyData.optional().get();
                            try {
                                key.optional = RecipeOptional.unit(((Pair)key.codec.decode(jsonOps, (Object)optionalJson).getOrThrow()).getFirst());
                            }
                            catch (Exception ex) {
                                throw new IllegalArgumentException("Failed to create optional value for key '" + String.valueOf(key) + "' of '" + String.valueOf(builder.id) + "' from " + String.valueOf(optionalJson), ex);
                            }
                        }
                        if (!keyData.alternativeNames().isEmpty()) {
                            key.names.addAll(keyData.alternativeNames());
                        }
                        key.excluded = keyData.excluded();
                        if (!keyData.functionNames().isEmpty()) {
                            key.functionNames = keyData.functionNames();
                        }
                        key.alwaysWrite = keyData.alwaysWrite();
                        builder.keys.add(key);
                    }
                    catch (Exception ex) {
                        ConsoleJS.SERVER.error("Error parsing recipe schema '" + String.valueOf(builder.id) + "' key " + keyData.name(), ex);
                    }
                }
            }
            if (builder.data.constructors().isPresent()) {
                builder.constructors = builder.data.constructors().get();
            }
            if (builder.data.unique().isPresent()) {
                builder.unique = builder.data.unique().get();
            }
            if (builder.data.functions().isPresent()) {
                builder.functions = builder.data.functions().get();
            }
            if (!builder.data.overrideKeys().isEmpty()) {
                builder.overrideKeys = builder.data.overrideKeys();
            }
            if (!builder.data.postProcessors().isPresent()) continue;
            builder.postProcessors = builder.data.postProcessors().get();
        }
        for (RecipeSchemaBuilder builder : map.values()) {
            schema = builder.getSchema(jsonOps);
            for (RecipeConstructor constructor : schema.constructors().values()) {
                for (RecipeKey<?> key : schema.keys) {
                    if (key.optional == null || constructor.keys.contains(key) || constructor.overrides.containsKey(key)) continue;
                    constructor.defaultValue(key, (RecipeOptional)Cast.to(key.optional));
                }
            }
        }
        for (RecipeSchemaBuilder builder : map.values()) {
            schema = builder.getSchema(jsonOps);
            event.namespace(builder.id.getNamespace()).register(builder.id.getPath(), schema);
        }
    }

    private static final class RecipeSchemaBuilder {
        private final ResourceLocation id;
        private final RecipeSchemaData data;
        private RecipeSchema schema;
        private RecipeSchemaBuilder parent;
        private ResourceLocation overrideType;
        private List<RecipeKey<?>> keys;
        private List<RecipeSchemaData.ConstructorData> constructors;
        private Map<String, RecipeSchemaFunction> functions;
        private KubeRecipeFactory recipeFactory;
        private List<String> unique;
        private Boolean hidden;
        private Map<String, JsonElement> overrideKeys;
        private List<RecipePostProcessor> postProcessors;

        private RecipeSchemaBuilder(ResourceLocation id, RecipeSchemaData data) {
            this.id = id;
            this.data = data;
        }

        private List<RecipeKey<?>> getKeys() {
            if (this.keys != null) {
                if (this.data.merge().keys()) {
                    LinkedHashMap mergedKeys = new LinkedHashMap();
                    if (this.parent != null) {
                        for (RecipeKey<?> key : this.parent.getKeys()) {
                            mergedKeys.put(key.name, key);
                        }
                    }
                    for (RecipeKey<?> key : this.keys) {
                        mergedKeys.put(key.name, key);
                    }
                    return List.copyOf(mergedKeys.values());
                }
                return this.keys;
            }
            if (this.parent != null) {
                return this.parent.getKeys();
            }
            return List.of();
        }

        private List<RecipeSchemaData.ConstructorData> getConstructors() {
            if (this.constructors != null) {
                if (this.data.merge().constructors()) {
                    ArrayList<RecipeSchemaData.ConstructorData> list = new ArrayList<RecipeSchemaData.ConstructorData>();
                    if (this.parent != null) {
                        list.addAll(this.parent.getConstructors());
                    }
                    list.addAll(this.constructors);
                    return list;
                }
                return this.constructors;
            }
            if (this.parent != null) {
                return this.parent.getConstructors();
            }
            return List.of();
        }

        private void gatherFunctions(Map<String, RecipeSchemaFunction> list) {
            if (this.parent != null) {
                this.parent.gatherFunctions(list);
            }
            if (this.functions != null) {
                list.putAll(this.functions);
            }
        }

        private KubeRecipeFactory getRecipeFactory() {
            if (this.recipeFactory != null) {
                return this.recipeFactory;
            }
            if (this.parent != null) {
                return this.parent.getRecipeFactory();
            }
            return null;
        }

        private List<String> getUnique() {
            if (this.unique != null) {
                if (this.data.merge().unique()) {
                    LinkedHashSet<String> u = new LinkedHashSet<String>();
                    if (this.parent != null) {
                        u.addAll(this.parent.getUnique());
                    }
                    u.addAll(this.unique);
                    return List.copyOf(u);
                }
                return this.unique;
            }
            if (this.parent != null) {
                return this.parent.getUnique();
            }
            return List.of();
        }

        private boolean isHidden() {
            if (this.hidden != null) {
                return this.hidden;
            }
            if (this.parent != null) {
                return this.parent.isHidden();
            }
            return false;
        }

        private List<RecipePostProcessor> getPostProcessors() {
            if (this.postProcessors != null) {
                if (this.data.merge().postProcessors()) {
                    ArrayList<RecipePostProcessor> list = new ArrayList<RecipePostProcessor>();
                    if (this.parent != null) {
                        list.addAll(this.parent.getPostProcessors());
                    }
                    list.addAll(this.postProcessors);
                    return list;
                }
                return this.postProcessors;
            }
            if (this.parent != null) {
                return this.parent.getPostProcessors();
            }
            return List.of();
        }

        private RecipeSchema getSchema(DynamicOps<JsonElement> jsonOps) {
            if (this.schema == null) {
                if (this.overrideType != null || this.keys != null || this.constructors != null || this.functions != null || this.recipeFactory != null || this.unique != null || this.overrideKeys != null) {
                    List<RecipeSchemaData.ConstructorData> constructors;
                    List<RecipeKey<?>> keys = this.getKeys();
                    HashMap keyMap = new HashMap();
                    for (RecipeKey<?> key : keys) {
                        keyMap.put(key.name, key);
                    }
                    HashMap<String, RecipeSchemaFunction> functionMap = new HashMap<String, RecipeSchemaFunction>();
                    this.gatherFunctions(functionMap);
                    Reference2ObjectOpenHashMap keyOverrides = Map.of();
                    if (this.overrideKeys != null) {
                        keyOverrides = new Reference2ObjectOpenHashMap(this.overrideKeys.size());
                        for (Map.Entry<String, JsonElement> entry : this.overrideKeys.entrySet()) {
                            RecipeKey key = (RecipeKey)keyMap.get(entry.getKey());
                            if (key != null) {
                                try {
                                    keyOverrides.put(key, RecipeOptional.unit(((Pair)key.codec.decode(jsonOps, (Object)entry.getValue()).getOrThrow()).getFirst()));
                                    continue;
                                }
                                catch (Exception ex) {
                                    throw new IllegalArgumentException("Failed to create optional value for key '" + String.valueOf(key) + "' of '" + String.valueOf(this.id) + "' from " + String.valueOf(entry.getValue()), ex);
                                }
                            }
                            throw new NullPointerException("Key '" + entry.getKey() + "' not found in key overrides of recipe schema '" + String.valueOf(this.id) + "'");
                        }
                    }
                    this.schema = new RecipeSchema((Map<RecipeKey<?>, RecipeOptional<?>>)keyOverrides, this.getKeys());
                    this.schema.typeOverride = this.overrideType;
                    KubeRecipeFactory rf = this.getRecipeFactory();
                    if (rf != null) {
                        this.schema.recipeFactory = rf;
                    }
                    if (!(constructors = this.getConstructors()).isEmpty()) {
                        for (RecipeSchemaData.ConstructorData c : constructors) {
                            ArrayList<RecipeKey> cKeys = new ArrayList<RecipeKey>();
                            for (String string : c.keys()) {
                                RecipeKey key = (RecipeKey)keyMap.get(string);
                                if (key != null) {
                                    cKeys.add(key);
                                    continue;
                                }
                                throw new NullPointerException("Key '" + string + "' not found in constructor of recipe schema '" + String.valueOf(this.id) + "'");
                            }
                            RecipeConstructor constructor = new RecipeConstructor(List.copyOf(cKeys));
                            if (!c.overrides().isEmpty()) {
                                for (Map.Entry<String, JsonElement> entry : c.overrides().entrySet()) {
                                    RecipeKey key = (RecipeKey)keyMap.get(entry.getKey());
                                    if (key != null) {
                                        try {
                                            constructor.overrideValue(key, Cast.to(key.codec.parse(jsonOps, (Object)entry.getValue()).getOrThrow()));
                                            continue;
                                        }
                                        catch (Exception ex) {
                                            throw new IllegalArgumentException("Failed to create optional value for key '" + String.valueOf(key) + "' of '" + String.valueOf(this.id) + "' from " + String.valueOf(entry.getValue()), ex);
                                        }
                                    }
                                    throw new NullPointerException("Key '" + entry.getKey() + "' not found in overrides of constructor of recipe schema '" + String.valueOf(this.id) + "'");
                                }
                            }
                            this.schema.constructor(constructor);
                        }
                    }
                    for (Map.Entry<String, RecipeSchemaFunction> entry : functionMap.entrySet()) {
                        DataResult<ResolvedRecipeSchemaFunction> func = entry.getValue().resolve(jsonOps, this.schema);
                        if (func.isSuccess()) {
                            this.schema.function(new RecipeFunctionInstance(entry.getKey(), (ResolvedRecipeSchemaFunction)func.getOrThrow()));
                            continue;
                        }
                        throw new NullPointerException("Failed to parse function '" + entry.getKey() + "' of recipe schema '" + String.valueOf(this.id) + "': " + func.error().map(DataResult.Error::message).orElse("Unknown Error"));
                    }
                    List<String> uniqueKeyNames = this.getUnique();
                    if (!uniqueKeyNames.isEmpty()) {
                        ArrayList uniqueKeys = new ArrayList();
                        for (String keyName : uniqueKeyNames) {
                            RecipeKey recipeKey = (RecipeKey)keyMap.get(keyName);
                            if (recipeKey != null) {
                                uniqueKeys.add(recipeKey);
                                continue;
                            }
                            throw new NullPointerException("Key '" + keyName + "' not found in unique keys of recipe schema '" + String.valueOf(this.id) + "'");
                        }
                        this.schema.uniqueIds(uniqueKeys);
                    }
                    this.schema.hidden = this.isHidden();
                    for (RecipePostProcessor postProcessor : this.getPostProcessors()) {
                        this.schema.postProcessor(postProcessor);
                    }
                } else if (this.parent != null) {
                    this.schema = this.parent.getSchema(jsonOps);
                } else {
                    this.schema = new RecipeSchema(Map.of(), List.of());
                    this.schema.constructor(new RecipeKey[0]);
                }
            }
            return this.schema;
        }
    }
}

